/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.client;

import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.resource.log.PipeLogger;
import org.apache.iotdb.commons.pipe.sink.client.IoTDBClientManager;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.sink.client.IoTDBDataNodeCacheLeaderClientManager;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataNodeAsyncClientManager
extends IoTDBClientManager
implements IoTDBDataNodeCacheLeaderClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeAsyncClientManager.class);
    private final Set<TEndPoint> endPointSet;
    private static final Map<String, Integer> RECEIVER_ATTRIBUTES_REF_COUNT = new ConcurrentHashMap<String, Integer>();
    private final String receiverAttributes;
    private static final Map<String, IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>> ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER = new ConcurrentHashMap<String, IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>>();
    private static final Map<String, ExecutorService> TS_FILE_ASYNC_EXECUTOR_HOLDER = new ConcurrentHashMap<String, ExecutorService>();
    private static final AtomicInteger id = new AtomicInteger(0);
    private final IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> endPoint2Client;
    private ExecutorService executor;
    private final LoadBalancer loadBalancer;
    private volatile boolean isClosed = false;
    private final Map<TEndPoint, Long> unhealthyEndPointMap = new ConcurrentHashMap<TEndPoint, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoTDBDataNodeAsyncClientManager(List<TEndPoint> endPoints, boolean useLeaderCache, String loadBalanceStrategy, String username, String password, boolean shouldReceiverConvertOnTypeMismatch, String loadTsFileStrategy, boolean validateTsFile, boolean shouldMarkAsPipeRequest, boolean isTSFileUsed) {
        super(endPoints, username, password, shouldReceiverConvertOnTypeMismatch, loadTsFileStrategy, useLeaderCache, validateTsFile, shouldMarkAsPipeRequest);
        this.endPointSet = new HashSet<TEndPoint>(endPoints);
        this.receiverAttributes = String.format("%s-%s-%s-%s-%s-%s", Base64.getEncoder().encodeToString((username + ":" + password).getBytes()), shouldReceiverConvertOnTypeMismatch, loadTsFileStrategy, validateTsFile, shouldMarkAsPipeRequest, isTSFileUsed);
        Object object = IoTDBDataNodeAsyncClientManager.class;
        synchronized (IoTDBDataNodeAsyncClientManager.class) {
            if (!ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.containsKey(this.receiverAttributes)) {
                ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.putIfAbsent(this.receiverAttributes, (IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient>)new IClientManager.Factory().createClientManager((IClientPoolFactory)(isTSFileUsed ? new ClientPoolFactory.AsyncPipeTsFileDataTransferServiceClientPoolFactory() : new ClientPoolFactory.AsyncPipeDataTransferServiceClientPoolFactory())));
            }
            this.endPoint2Client = ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.get(this.receiverAttributes);
            if (isTSFileUsed) {
                if (!TS_FILE_ASYNC_EXECUTOR_HOLDER.containsKey(this.receiverAttributes)) {
                    TS_FILE_ASYNC_EXECUTOR_HOLDER.putIfAbsent(this.receiverAttributes, IoTDBThreadPoolFactory.newFixedThreadPool((int)PipeConfig.getInstance().getPipeRealTimeQueueMaxWaitingTsFileSize(), (String)(ThreadName.PIPE_TSFILE_ASYNC_SEND_POOL.getName() + "-" + id.getAndIncrement())));
                }
                this.executor = TS_FILE_ASYNC_EXECUTOR_HOLDER.get(this.receiverAttributes);
            }
            RECEIVER_ATTRIBUTES_REF_COUNT.compute(this.receiverAttributes, (attributes, refCount) -> refCount == null ? 1 : refCount + 1);
            // ** MonitorExit[var11_11] (shouldn't be in output)
            switch (loadBalanceStrategy) {
                case "round-robin": {
                    this.loadBalancer = new RoundRobinLoadBalancer();
                    break;
                }
                case "random": {
                    this.loadBalancer = new RandomLoadBalancer();
                    break;
                }
                case "priority": {
                    this.loadBalancer = new PriorityLoadBalancer();
                    break;
                }
                default: {
                    LOGGER.warn("Unknown load balance strategy: {}, use round-robin strategy instead.", (Object)loadBalanceStrategy);
                    this.loadBalancer = new RoundRobinLoadBalancer();
                }
            }
            return;
        }
    }

    public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
        return this.loadBalancer.borrowClient();
    }

    public AsyncPipeDataTransferServiceClient borrowClient(String deviceId) throws Exception {
        if (!this.useLeaderCache || Objects.isNull(deviceId)) {
            return this.borrowClient();
        }
        return this.borrowClient(LEADER_CACHE_MANAGER.getLeaderEndPoint(deviceId));
    }

    public AsyncPipeDataTransferServiceClient borrowClient(TEndPoint endPoint) throws Exception {
        if (!this.useLeaderCache || Objects.isNull(endPoint) || this.isUnhealthy(endPoint)) {
            return this.borrowClient();
        }
        try {
            AsyncPipeDataTransferServiceClient client = (AsyncPipeDataTransferServiceClient)this.endPoint2Client.borrowClient((Object)endPoint);
            if (this.handshakeIfNecessary(endPoint, client)) {
                return client;
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to borrow client {}:{} for cached leader.", new Object[]{endPoint.getIp(), endPoint.getPort(), e});
        }
        return this.borrowClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handshakeIfNecessary(final TEndPoint targetNodeUrl, final AsyncPipeDataTransferServiceClient client) throws Exception {
        block12: {
            if (client.isHandshakeFinished()) {
                return true;
            }
            final AtomicBoolean isHandshakeFinished = new AtomicBoolean(false);
            final AtomicReference resp = new AtomicReference();
            final AtomicReference exception = new AtomicReference();
            AsyncMethodCallback<TPipeTransferResp> callback = new AsyncMethodCallback<TPipeTransferResp>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onComplete(TPipeTransferResp response) {
                    resp.set(response);
                    if (response.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), (String)"Handshake error with receiver %s:%s, code: %s, message: %s.", (Object[])new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage()});
                        exception.set(new PipeConnectionException(String.format("Handshake error with receiver %s:%s, code: %d, message: %s.", targetNodeUrl.getIp(), targetNodeUrl.getPort(), response.getStatus().getCode(), response.getStatus().getMessage())));
                    } else {
                        LOGGER.info("Handshake successfully with receiver {}:{}.", (Object)targetNodeUrl.getIp(), (Object)targetNodeUrl.getPort());
                        client.markHandshakeFinished();
                    }
                    isHandshakeFinished.set(true);
                    AtomicBoolean atomicBoolean = isHandshakeFinished;
                    synchronized (atomicBoolean) {
                        isHandshakeFinished.notifyAll();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onError(Exception e) {
                    ThriftClient.resolveException((Throwable)e, (ThriftClient)client);
                    PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), (Throwable)e, (String)"Handshake error with receiver %s:%s.", (Object[])new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort()});
                    exception.set(e);
                    isHandshakeFinished.set(true);
                    AtomicBoolean atomicBoolean = isHandshakeFinished;
                    synchronized (atomicBoolean) {
                        isHandshakeFinished.notifyAll();
                    }
                }
            };
            try {
                client.setShouldReturnSelf(false);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("clusterID", IoTDBDescriptor.getInstance().getConfig().getClusterId());
                params.put("timestampPrecision", CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
                params.put("convertOnTypeMismatch", Boolean.toString(this.shouldReceiverConvertOnTypeMismatch));
                params.put("loadTsFileStrategy", this.loadTsFileStrategy);
                params.put("username", this.username);
                params.put("password", this.password);
                params.put("validateTsFile", Boolean.toString(this.validateTsFile));
                params.put("markAsPipeRequest", Boolean.toString(this.shouldMarkAsPipeRequest));
                client.setTimeoutDynamically(PipeConfig.getInstance().getPipeSinkHandshakeTimeoutMs());
                client.pipeTransfer((TPipeTransferReq)PipeTransferDataNodeHandshakeV2Req.toTPipeTransferReq(params), (AsyncMethodCallback)callback);
                this.waitHandshakeFinished(isHandshakeFinished);
                if (resp.get() != null && ((TPipeTransferResp)resp.get()).getStatus().getCode() == TSStatusCode.PIPE_TYPE_ERROR.getStatusCode()) {
                    PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), (String)"Handshake error by PipeTransferHandshakeV2Req with receiver %s:%s retry to handshake by PipeTransferHandshakeV1Req.", (Object[])new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort()});
                    this.supportModsIfIsDataNodeReceiver = false;
                    isHandshakeFinished.set(false);
                    resp.set(null);
                    exception.set(null);
                    client.setTimeoutDynamically(PipeConfig.getInstance().getPipeSinkHandshakeTimeoutMs());
                    client.pipeTransfer((TPipeTransferReq)PipeTransferDataNodeHandshakeV1Req.toTPipeTransferReq(CommonDescriptor.getInstance().getConfig().getTimestampPrecision()), (AsyncMethodCallback)callback);
                    this.waitHandshakeFinished(isHandshakeFinished);
                }
                if (exception.get() != null) {
                    this.markUnhealthy(targetNodeUrl);
                    throw new PipeConnectionException("Failed to handshake.", (Throwable)exception.get());
                }
                this.markHealthy(targetNodeUrl);
                if (!this.isClosed) break block12;
            }
            catch (TException e) {
                try {
                    client.resetMethodStateIfStopped();
                    this.markUnhealthy(targetNodeUrl);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this.isClosed) {
                        try {
                            client.close();
                            client.invalidateAll();
                        }
                        catch (Exception e2) {
                            LOGGER.warn("Failed to close client {}:{} after handshake failure when the manager is closed.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), e2});
                        }
                    }
                    client.setShouldReturnSelf(true);
                    client.returnSelf();
                    throw throwable;
                }
            }
            try {
                client.close();
                client.invalidateAll();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close client {}:{} after handshake failure when the manager is closed.", new Object[]{targetNodeUrl.getIp(), targetNodeUrl.getPort(), e});
            }
        }
        client.setShouldReturnSelf(true);
        client.returnSelf();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitHandshakeFinished(AtomicBoolean isHandshakeFinished) {
        try {
            while (!isHandshakeFinished.get()) {
                if (this.isClosed) {
                    throw new PipeConnectionException("Timed out when waiting for client handshake finish.");
                }
                AtomicBoolean atomicBoolean = isHandshakeFinished;
                synchronized (atomicBoolean) {
                    isHandshakeFinished.wait(1L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PipeException("Interrupted while waiting for handshake response.", (Throwable)e);
        }
    }

    public void updateLeaderCache(String deviceId, TEndPoint endPoint) {
        if (!this.useLeaderCache || deviceId == null || endPoint == null) {
            return;
        }
        if (!this.endPointSet.contains(endPoint)) {
            this.endPointList.add(endPoint);
            this.endPointSet.add(endPoint);
        }
        LEADER_CACHE_MANAGER.updateLeaderEndPoint(deviceId, endPoint);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isClosed = true;
        Class<IoTDBDataNodeAsyncClientManager> clazz = IoTDBDataNodeAsyncClientManager.class;
        synchronized (IoTDBDataNodeAsyncClientManager.class) {
            RECEIVER_ATTRIBUTES_REF_COUNT.computeIfPresent(this.receiverAttributes, (attributes, refCount) -> {
                if (refCount <= 1) {
                    ExecutorService executor;
                    IClientManager<TEndPoint, AsyncPipeDataTransferServiceClient> clientManager = ASYNC_PIPE_DATA_TRANSFER_CLIENT_MANAGER_HOLDER.remove(this.receiverAttributes);
                    if (clientManager != null) {
                        try {
                            clientManager.close();
                            LOGGER.info("Closed AsyncPipeDataTransferServiceClientManager for receiver attributes: {}", (Object)this.receiverAttributes);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to close AsyncPipeDataTransferServiceClientManager for receiver attributes: {}", (Object)this.receiverAttributes, (Object)e);
                        }
                    }
                    if ((executor = TS_FILE_ASYNC_EXECUTOR_HOLDER.remove(this.receiverAttributes)) != null) {
                        try {
                            executor.shutdown();
                            LOGGER.info("Successfully shutdown executor {}.", (Object)executor);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to shutdown executor {}.", (Object)executor);
                        }
                    }
                    return null;
                }
                return refCount - 1;
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private boolean isUnhealthy(TEndPoint endPoint) {
        Long downTime = this.unhealthyEndPointMap.get(endPoint);
        if (downTime == null) {
            return false;
        }
        if (System.currentTimeMillis() - downTime > PipeConfig.getInstance().getPipeCheckAllSyncClientLiveTimeIntervalMs()) {
            this.markHealthy(endPoint);
            return false;
        }
        return true;
    }

    private void markUnhealthy(TEndPoint endPoint) {
        this.unhealthyEndPointMap.put(endPoint, System.currentTimeMillis());
    }

    private void markHealthy(TEndPoint endPoint) {
        this.unhealthyEndPointMap.remove(endPoint);
    }

    private class RoundRobinLoadBalancer
    implements LoadBalancer {
        private RoundRobinLoadBalancer() {
        }

        @Override
        public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
            AsyncPipeDataTransferServiceClient client;
            int clientSize = IoTDBDataNodeAsyncClientManager.this.endPointList.size();
            long n = 0L;
            while (true) {
                TEndPoint targetNodeUrl;
                if (IoTDBDataNodeAsyncClientManager.this.isUnhealthy(targetNodeUrl = (TEndPoint)IoTDBDataNodeAsyncClientManager.this.endPointList.get((int)(IoTDBDataNodeAsyncClientManager.this.currentClientIndex++ % (long)clientSize))) && n < (long)clientSize) {
                    ++n;
                    continue;
                }
                client = (AsyncPipeDataTransferServiceClient)IoTDBDataNodeAsyncClientManager.this.endPoint2Client.borrowClient((Object)targetNodeUrl);
                if (IoTDBDataNodeAsyncClientManager.this.handshakeIfNecessary(targetNodeUrl, client)) break;
            }
            return client;
        }
    }

    private static interface LoadBalancer {
        public AsyncPipeDataTransferServiceClient borrowClient() throws Exception;
    }

    private class RandomLoadBalancer
    implements LoadBalancer {
        private RandomLoadBalancer() {
        }

        @Override
        public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
            AsyncPipeDataTransferServiceClient client;
            int clientSize = IoTDBDataNodeAsyncClientManager.this.endPointList.size();
            long n = 0L;
            while (true) {
                TEndPoint targetNodeUrl;
                if (IoTDBDataNodeAsyncClientManager.this.isUnhealthy(targetNodeUrl = (TEndPoint)IoTDBDataNodeAsyncClientManager.this.endPointList.get((int)(Math.random() * (double)clientSize))) && n <= (long)clientSize) {
                    ++n;
                    continue;
                }
                client = (AsyncPipeDataTransferServiceClient)IoTDBDataNodeAsyncClientManager.this.endPoint2Client.borrowClient((Object)targetNodeUrl);
                if (IoTDBDataNodeAsyncClientManager.this.handshakeIfNecessary(targetNodeUrl, client)) break;
            }
            return client;
        }
    }

    private class PriorityLoadBalancer
    implements LoadBalancer {
        private PriorityLoadBalancer() {
        }

        @Override
        public AsyncPipeDataTransferServiceClient borrowClient() throws Exception {
            AsyncPipeDataTransferServiceClient client;
            int clientSize = IoTDBDataNodeAsyncClientManager.this.endPointList.size();
            long n = 0L;
            block0: while (true) {
                Iterator iterator = IoTDBDataNodeAsyncClientManager.this.endPointList.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    TEndPoint targetNodeUrl = (TEndPoint)iterator.next();
                    if (IoTDBDataNodeAsyncClientManager.this.isUnhealthy(targetNodeUrl) && n <= (long)clientSize) {
                        ++n;
                        continue;
                    }
                    client = (AsyncPipeDataTransferServiceClient)IoTDBDataNodeAsyncClientManager.this.endPoint2Client.borrowClient((Object)targetNodeUrl);
                    if (IoTDBDataNodeAsyncClientManager.this.handshakeIfNecessary(targetNodeUrl, client)) break block0;
                }
                break;
            }
            return client;
        }
    }
}

