/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import org.apache.baremaps.geoparquet.GeoParquetGroup;
import org.apache.baremaps.geoparquet.GeoParquetMetadata;
import org.apache.baremaps.geoparquet.GeoParquetWriteSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.schema.MessageType;

public class GeoParquetWriter {
    private GeoParquetWriter() {
    }

    public static Builder builder(Path file) {
        return new Builder(file);
    }

    public static class Builder
    extends ParquetWriter.Builder<GeoParquetGroup, Builder> {
        private MessageType type = null;
        private GeoParquetMetadata metadata = null;

        private Builder(Path file) {
            super(file);
        }

        public Builder withType(MessageType type) {
            this.type = type;
            return this;
        }

        public Builder withGeoParquetMetadata(GeoParquetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        protected WriteSupport<GeoParquetGroup> getWriteSupport(Configuration conf) {
            return this.getWriteSupport((ParquetConfiguration)null);
        }

        protected WriteSupport<GeoParquetGroup> getWriteSupport(ParquetConfiguration conf) {
            return new GeoParquetWriteSupport(this.type, this.metadata);
        }

        protected Builder self() {
            return this;
        }
    }
}

