/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper;

import java.util.EnumMap;
import java.util.Locale;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Names;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

public enum GeometryType {
    GEOMETRY("Geometry"),
    POINT("Point"),
    LINESTRING("LineString"),
    POLYGON("Polygon"),
    MULTIPOINT("MultiPoint"),
    MULTILINESTRING("MultiLineString"),
    MULTIPOLYGON("MultiPolygon"),
    GEOMETRYCOLLECTION("GeometryCollection");

    public final String name;
    private final EnumMap<GeometryLibrary, TypeName> typeNames;
    private static volatile NameSpace namespace;

    private GeometryType(String name) {
        this.name = name;
        this.typeNames = new EnumMap(GeometryLibrary.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TypeName getTypeName(Geometries<?> library) {
        TypeName value;
        EnumMap<GeometryLibrary, TypeName> enumMap = this.typeNames;
        synchronized (enumMap) {
            value = this.typeNames.get(library.library);
        }
        if (value == null) {
            NameSpace scope = namespace;
            if (scope == null) {
                namespace = scope = Names.createTypeName((CharSequence)"OGC", null, (CharSequence)"Geometry").scope();
            }
            value = DefaultNameFactory.provider().createTypeName(scope, (CharSequence)this.name, library.getGeometryClass(this));
            EnumMap<GeometryLibrary, TypeName> enumMap2 = this.typeNames;
            synchronized (enumMap2) {
                TypeName existing = this.typeNames.put(library.library, value);
                if (existing != null) {
                    value = existing;
                    this.typeNames.put(library.library, value);
                }
            }
        }
        return value;
    }

    public final int binaryType() {
        return this.ordinal();
    }

    public final boolean isCollection() {
        return this.ordinal() >= MULTIPOINT.ordinal();
    }

    public static GeometryType forName(String name) {
        int length;
        if (name != null && (length = (name = name.trim().toUpperCase(Locale.US)).length()) > 0) {
            if (name.charAt(length - 1) == 'M') {
                --length;
            }
            if (length > 0 && name.charAt(length - 1) == 'Z') {
                --length;
            }
            if ((name = name.substring(0, length).replace("_", "")).equals("GEOMCOLLECTION")) {
                return GEOMETRYCOLLECTION;
            }
            return GeometryType.valueOf(name);
        }
        return null;
    }

    public static GeometryType forBinaryType(int type) {
        if (type >= 1000 && type < 4000) {
            type %= 1000;
        }
        switch (type) {
            default: {
                return null;
            }
            case 0: {
                return GEOMETRY;
            }
            case 1: {
                return POINT;
            }
            case 2: {
                return LINESTRING;
            }
            case 3: {
                return POLYGON;
            }
            case 4: {
                return MULTIPOINT;
            }
            case 5: {
                return MULTILINESTRING;
            }
            case 6: {
                return MULTIPOLYGON;
            }
            case 7: 
        }
        return GEOMETRYCOLLECTION;
    }
}

