/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.metadata.sql.util.SQLBuilder;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.FeatureAdapter;
import org.apache.sis.storage.sql.feature.FeatureAnalyzer;
import org.apache.sis.storage.sql.feature.FeatureStream;
import org.apache.sis.storage.sql.feature.PrimaryKey;
import org.apache.sis.storage.sql.feature.Relation;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.opengis.geometry.Envelope;
import org.opengis.util.GenericName;

final class Table
extends AbstractFeatureSet {
    final Database<?> database;
    final DefaultFeatureType featureType;
    private final String query;
    final TableReference name;
    final Column[] attributes;
    final PrimaryKey primaryKey;
    final Relation[] importedKeys;
    final Relation[] exportedKeys;
    final boolean hasGeometry;
    final boolean hasRaster;
    private Map<String, Column> attributeToColumns;
    private FeatureAdapter adapter;
    private WeakValueHashMap<?, Object> instanceForPrimaryKeys;
    private boolean isEnvelopeAnalyzed;

    Table(Database<?> database, FeatureAnalyzer analyzer, String query) throws Exception {
        super(database.listeners, false);
        this.database = database;
        this.query = query;
        this.name = analyzer.id;
        this.importedKeys = analyzer.getForeignerKeys(Relation.Direction.IMPORT);
        this.exportedKeys = analyzer.getForeignerKeys(Relation.Direction.EXPORT);
        this.attributes = analyzer.createAttributes();
        this.primaryKey = analyzer.createAssociations(this.exportedKeys);
        this.featureType = analyzer.buildFeatureType();
        this.hasGeometry = analyzer.hasGeometry;
        this.hasRaster = analyzer.hasRaster;
    }

    Table(Table parent) {
        super(parent.listeners, false);
        this.database = parent.database;
        this.query = parent.query;
        this.name = parent.name;
        this.primaryKey = parent.primaryKey;
        this.attributes = parent.attributes;
        this.importedKeys = parent.importedKeys;
        this.exportedKeys = parent.exportedKeys;
        this.featureType = parent.featureType;
        this.hasGeometry = parent.hasGeometry;
        this.hasRaster = parent.hasRaster;
    }

    final void setDeferredSearchTables(Analyzer analyzer, Map<GenericName, Table> tables) throws DataStoreException {
        block8: for (Relation.Direction direction : Relation.Direction.values()) {
            Relation[] relations;
            switch (direction) {
                case IMPORT: {
                    relations = this.importedKeys;
                    break;
                }
                case EXPORT: {
                    relations = this.exportedKeys;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            for (Relation relation : relations) {
                PrimaryKey referenced;
                if (!relation.isSearchTableDeferred()) continue;
                DefaultAssociationRole association = (DefaultAssociationRole)this.featureType.getProperty(relation.propertyName);
                Table table = tables.get(association.getValueType().getName());
                if (table == null) {
                    throw new InternalDataStoreException(association.toString());
                }
                switch (direction) {
                    case IMPORT: {
                        referenced = table.primaryKey;
                        break;
                    }
                    case EXPORT: {
                        referenced = this.primaryKey;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)direction);
                    }
                }
                if (referenced == null) continue;
                relation.setSearchTable(analyzer, table, referenced, direction);
            }
        }
    }

    private static void appendAll(TreeTable.Node parent, Relation[] children, String arrow) {
        for (Relation child : children) {
            child.appendTo(parent, arrow);
        }
    }

    final void appendTo(TreeTable.Node parent) {
        parent = Relation.newChild(parent, this.featureType.getName().toString());
        for (Column attribute : this.attributes) {
            TableReference.newChild(parent, attribute.propertyName);
        }
        Table.appendAll(parent, this.importedKeys, " \u2192 ");
        Table.appendAll(parent, this.exportedKeys, " \u2190 ");
    }

    public String toString() {
        return TableReference.toString((Object)this, n -> this.appendTo((TreeTable.Node)n));
    }

    public final Optional<GenericName> getIdentifier() {
        return Optional.of(this.featureType.getName().toFullyQualifiedName());
    }

    public final DefaultFeatureType getType() {
        return this.featureType;
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        if (this.hasGeometry) {
            try {
                boolean recall = this.isEnvelopeAnalyzed;
                this.isEnvelopeAnalyzed = true;
                return Optional.ofNullable(this.database.getEstimatedExtent(this.name, this.attributes, recall));
            }
            catch (SQLException e) {
                throw new DataStoreException((Throwable)e);
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Column getColumn(String xpath) {
        Map<String, Column> m;
        Table table = this;
        synchronized (table) {
            m = this.attributeToColumns;
            if (m == null) {
                m = new HashMap<String, Column>(Containers.hashMapCapacity((int)this.attributes.length));
                for (Column c : this.attributes) {
                    String label = c.propertyName;
                    m.put(label, c);
                    int s = label.lastIndexOf(58);
                    if (s < 0) continue;
                    m.putIfAbsent(label.substring(s + 1), c);
                }
                this.attributeToColumns = m;
            }
        }
        return m.get(xpath);
    }

    final Relation getInverseOf(Relation exported, TableReference exportedOwner) {
        if (this.name.equals(exported)) {
            for (Relation relation : this.importedKeys) {
                if (!relation.equals(exportedOwner) || !relation.isInverseOf(exported)) continue;
                return relation;
            }
        }
        return null;
    }

    final synchronized WeakValueHashMap<?, Object> instanceForPrimaryKeys() {
        if (this.instanceForPrimaryKeys == null) {
            this.instanceForPrimaryKeys = new WeakValueHashMap(this.primaryKey.valueClass);
        }
        return this.instanceForPrimaryKeys;
    }

    final void appendFromClause(SQLBuilder sql) {
        sql.append(" FROM ");
        if (this.query != null) {
            sql.append('(').append(this.query).append(") AS USER_QUERY");
        } else {
            sql.appendIdentifier(this.name.catalog, this.name.schema, this.name.table);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final long countRows(DatabaseMetaData metadata, boolean distinct, boolean approximate) throws SQLException {
        long count = -1L;
        String[] names = TableReference.splitName(this.featureType.getName());
        try (ResultSet reflect = metadata.getIndexInfo(names[2], names[1], names[0], distinct, approximate);){
            while (reflect.next()) {
                long n = reflect.getLong("CARDINALITY");
                if (reflect.wasNull()) continue;
                if (reflect.getShort("TYPE") == 0) {
                    long l = n;
                    return l;
                }
                if (n <= count) continue;
                count = n;
            }
            return count;
        }
    }

    final synchronized FeatureAdapter adapter(Connection connection) throws SQLException, InternalDataStoreException {
        if (this.adapter == null) {
            this.adapter = new FeatureAdapter(this, connection.getMetaData());
        }
        return this.adapter;
    }

    public Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        return new FeatureStream(this, parallel);
    }
}

