/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Arrays;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.GeodeticOperation;
import org.apache.sis.referencing.operation.provider.GeographicOffsets2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Transformation;

@XmlTransient
public class GeographicOffsets
extends GeodeticOperation {
    private static final long serialVersionUID = -6246011184175753328L;
    static final ParameterDescriptor<Double> TX;
    static final ParameterDescriptor<Double> TY;
    static final ParameterDescriptor<Double> TZ;
    private static final ParameterDescriptorGroup PARAMETERS;
    private static final GeographicOffsets[] REDIMENSIONED;

    @Override
    GeodeticOperation redimensioned(int indexOfDim) {
        return REDIMENSIONED[indexOfDim];
    }

    static GeographicOffsets provider2D() {
        return REDIMENSIONED[0];
    }

    @Deprecated
    public GeographicOffsets() {
        super(REDIMENSIONED[3]);
    }

    @Deprecated
    GeographicOffsets(GeographicOffsets copy) {
        super(copy);
    }

    private GeographicOffsets(int indexOfDim) {
        this(PARAMETERS, indexOfDim);
    }

    GeographicOffsets(ParameterDescriptorGroup parameters, int indexOfDim) {
        super(Transformation.class, parameters, indexOfDim, EllipsoidalCS.class, false, EllipsoidalCS.class, false);
    }

    ParameterDescriptor<Double> vertical() {
        return TZ;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException {
        Parameters pv = Parameters.castOrWrap(values);
        return MathTransforms.translation(pv.doubleValue(TX), pv.doubleValue(TY), pv.doubleValue(this.vertical()));
    }

    static {
        ParameterBuilder builder = GeographicOffsets.builder();
        TY = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8601")).addName("Latitude offset")).create(0.0, Units.DEGREE);
        TX = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8602")).addName("Longitude offset")).create(0.0, Units.DEGREE);
        TZ = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8603")).addName("Vertical Offset")).create(0.0, Units.METRE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9660")).addName("Geographic3D offsets")).createGroup(new GeneralParameterDescriptor[]{TY, TX, TZ});
        REDIMENSIONED = new GeographicOffsets[4];
        Arrays.setAll(REDIMENSIONED, i -> i == 0 ? new GeographicOffsets2D(i) : new GeographicOffsets(i));
    }
}

