/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.Identifiers;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.DefaultFormula;
import org.apache.sis.referencing.util.NilReferencingObject;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.bind.gco.StringAdapter;
import org.apache.sis.xml.bind.referencing.CC_OperationMethod;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Formula;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.InternationalString;

@XmlType(name="OperationMethodType", propOrder={"formulaCitation", "formulaDescription", "sourceDimensions", "targetDimensions", "descriptors"})
@XmlRootElement(name="OperationMethod")
public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = 6612049971779439502L;
    private Formula formula;
    private ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(Map<String, ?> properties, ParameterDescriptorGroup parameters) {
        super(properties);
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameters);
        Object value = properties.get("formula");
        if (value == null || value instanceof Formula) {
            this.formula = (Formula)value;
        } else if (value instanceof Citation) {
            this.formula = new DefaultFormula((Citation)value);
        } else if (value instanceof CharSequence) {
            this.formula = new DefaultFormula((CharSequence)value);
        } else {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)58, (Object)"formula", value.getClass()));
        }
        this.parameters = parameters;
    }

    public DefaultOperationMethod(MathTransform transform) {
        super(DefaultOperationMethod.getProperties(transform));
        if (transform instanceof Parameterized) {
            this.parameters = ((Parameterized)transform).getParameterDescriptors();
        }
    }

    private static Map<String, ?> getProperties(MathTransform transform) {
        ParameterDescriptorGroup parameters;
        ArgumentChecks.ensureNonNull((String)"transform", (Object)transform);
        if (transform instanceof Parameterized && (parameters = ((Parameterized)transform).getParameterDescriptors()) != null) {
            return DefaultOperationMethod.getProperties((IdentifiedObject)parameters, null);
        }
        return Map.of("name", NilReferencingObject.UNNAMED);
    }

    private static Map<String, Object> getProperties(IdentifiedObject info, Citation authority) {
        HashMap<String, Object> properties = new HashMap<String, Object>(IdentifiedObjects.getProperties(info, new String[0]));
        properties.put("name", new NamedIdentifier(authority, info.getName().getCode()));
        properties.remove("identifiers");
        return properties;
    }

    protected DefaultOperationMethod(OperationMethod method) {
        super((IdentifiedObject)method);
        this.formula = method.getFormula();
        this.parameters = method.getParameters();
    }

    public static DefaultOperationMethod castOrCopy(OperationMethod object) {
        return object == null || object instanceof DefaultOperationMethod ? (DefaultOperationMethod)object : new DefaultOperationMethod(object);
    }

    public Class<? extends OperationMethod> getInterface() {
        return OperationMethod.class;
    }

    public Class<? extends SingleOperation> getOperationType() {
        return SingleOperation.class;
    }

    public Formula getFormula() {
        return this.formula;
    }

    @Deprecated(since="1.1")
    @XmlElement(name="sourceDimensions")
    @XmlSchemaType(name="positiveInteger")
    public Integer getSourceDimensions() {
        return null;
    }

    @Deprecated(since="1.1")
    @XmlElement(name="targetDimensions")
    @XmlSchemaType(name="positiveInteger")
    public Integer getTargetDimensions() {
        return null;
    }

    public ParameterDescriptorGroup getParameters() {
        return this.parameters;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            OperationMethod that;
            switch (mode) {
                case STRICT: {
                    DefaultOperationMethod that2 = (DefaultOperationMethod)object;
                    return Objects.equals(this.formula, that2.formula) && Objects.equals(this.parameters, that2.parameters);
                }
                case BY_CONTRACT: {
                    if (Objects.equals(this.getFormula(), ((OperationMethod)object).getFormula())) break;
                    return false;
                }
                default: {
                    that = (OperationMethod)object;
                    Boolean match = Identifiers.hasCommonIdentifier(this.getIdentifiers(), (Iterable)that.getIdentifiers());
                    if (!(match != null ? match == false : !this.isHeuristicMatchForName(that.getName().getCode()) && !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)that, this.getName().getCode()))) break;
                    return false;
                }
            }
            that = (OperationMethod)object;
            return Objects.equals(this.getSourceDimensions(), that.getSourceDimensions()) && Objects.equals(this.getTargetDimensions(), that.getTargetDimensions()) && Utilities.deepEquals((Object)this.getParameters(), (Object)that.getParameters(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.parameters);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isWKT1 = formatter.getConvention().majorVersion() == 1;
        Citation authority = formatter.getNameAuthority();
        String name = IdentifiedObjects.getName(this, authority);
        ElementKind kind = ElementKind.METHOD;
        if (name == null) {
            Conversion conversion;
            FormattableObject parent = formatter.getEnclosingElement(isWKT1 ? 1 : 2);
            if (parent instanceof GeneralDerivedCRS && (conversion = ((GeneralDerivedCRS)parent).getConversionFromBase()) != null) {
                ParameterDescriptorGroup descriptor = conversion instanceof Parameterized ? ((Parameterized)conversion).getParameterDescriptors() : conversion.getParameterValues().getDescriptor();
                name = IdentifiedObjects.getName((IdentifiedObject)descriptor, authority);
            }
            if (name == null && (name = IdentifiedObjects.getName(this, null)) == null) {
                name = Vocabulary.getResources((Locale)formatter.getLocale()).getString((short)208);
                kind = ElementKind.NAME;
            }
        }
        formatter.append(name, kind);
        if (isWKT1) {
            Class<? extends SingleOperation> type = this.getOperationType();
            if (Projection.class.isAssignableFrom(type) || type.isAssignableFrom(Projection.class)) {
                return "Projection";
            }
            formatter.setInvalidWKT(this, null);
        }
        return "Method";
    }

    private DefaultOperationMethod() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    @XmlElement(name="formulaCitation")
    private Citation getFormulaCitation() {
        Formula formula = this.getFormula();
        return formula != null ? formula.getCitation() : null;
    }

    @XmlElement(name="formula")
    private String getFormulaDescription() {
        Formula formula = this.getFormula();
        return formula != null ? StringAdapter.toString((CharSequence)formula.getFormula()) : null;
    }

    private void setFormulaCitation(Citation citation) {
        if (this.formula == null || this.formula.getCitation() == null) {
            this.formula = this.formula == null ? new DefaultFormula(citation) : new DefaultFormula(this.formula.getFormula(), citation);
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultOperationMethod.class, (String)"setFormulaCitation", (String)"formulaCitation");
        }
    }

    private void setFormulaDescription(String description) {
        if (this.formula == null || this.formula.getFormula() == null) {
            this.formula = this.formula == null ? new DefaultFormula(description) : new DefaultFormula((InternationalString)new SimpleInternationalString(description), this.formula.getCitation());
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultOperationMethod.class, (String)"setFormulaDescription", (String)"formula");
        }
    }

    @XmlElement(name="parameter")
    private GeneralParameterDescriptor[] getDescriptors() {
        List descriptors;
        if (this.parameters != null && (descriptors = this.parameters.descriptors()) != null) {
            return CC_OperationMethod.filterImplicit((GeneralParameterDescriptor[])descriptors.toArray(GeneralParameterDescriptor[]::new));
        }
        return null;
    }

    private void setDescriptors(GeneralParameterDescriptor[] descriptors) {
        if (this.parameters == null) {
            this.parameters = CC_OperationMethod.group((Identifier)super.getName(), descriptors);
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultOperationMethod.class, (String)"setDescriptors", (String)"parameter");
        }
    }

    final void updateDescriptors(GeneralParameterDescriptor[] descriptors) {
        ParameterDescriptorGroup previous = this.parameters;
        this.parameters = new DefaultParameterDescriptorGroup(IdentifiedObjects.getProperties((IdentifiedObject)previous, new String[0]), previous.getMinimumOccurs(), previous.getMaximumOccurs(), descriptors);
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.parameters == null) {
            this.parameters = CC_OperationMethod.group((Identifier)super.getName(), new GeneralParameterDescriptor[0]);
        }
    }
}

