/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.baremaps.shapefile.DBaseFieldDescriptor;
import org.apache.baremaps.shapefile.ShapefileDescriptor;
import org.apache.baremaps.shapefile.ShapefileInputStream;
import org.apache.baremaps.store.DataSchema;

public class ShapefileReader {
    private File shapefile;
    private File databaseFile;
    private File shapeFileIndex;
    private DataSchema schema;
    private ShapefileDescriptor shapefileDescriptor;
    private List<DBaseFieldDescriptor> databaseFieldsDescriptors;

    public ShapefileReader(String shapefile) {
        Objects.requireNonNull(shapefile, "The shapefile to load cannot be null.");
        this.shapefile = new File(shapefile);
        StringBuilder dbfFileName = new StringBuilder(shapefile);
        String dbfSuffix = null;
        dbfSuffix = shapefile.endsWith("shp") ? "dbf" : dbfSuffix;
        dbfSuffix = shapefile.endsWith("SHP") ? "DBF" : dbfSuffix;
        dbfSuffix = shapefile.endsWith("Shp") ? "Dbf" : dbfSuffix;
        dbfSuffix = dbfSuffix == null ? "dbf" : dbfSuffix;
        dbfFileName.replace(shapefile.length() - 3, shapefile.length(), dbfSuffix);
        this.databaseFile = new File(dbfFileName.toString());
        StringBuilder shapeFileIndexName = new StringBuilder(shapefile);
        String shapeFileIndexSuffix = null;
        shapeFileIndexSuffix = shapefile.endsWith("shp") ? "shx" : shapeFileIndexSuffix;
        shapeFileIndexSuffix = shapefile.endsWith("SHP") ? "SHX" : shapeFileIndexSuffix;
        shapeFileIndexSuffix = shapefile.endsWith("Shp") ? "Shx" : shapeFileIndexSuffix;
        shapeFileIndexSuffix = shapeFileIndexSuffix == null ? "shx" : shapeFileIndexSuffix;
        shapeFileIndexName.replace(shapefile.length() - 3, shapefile.length(), shapeFileIndexSuffix);
        this.shapeFileIndex = new File(shapeFileIndexName.toString());
    }

    public ShapefileReader(String shpfile, String dbasefile) {
        Objects.requireNonNull(shpfile, "The shapefile to load cannot be null.");
        Objects.requireNonNull(dbasefile, "The DBase III file to load cannot be null.");
        this.shapefile = new File(shpfile);
        this.databaseFile = new File(dbasefile);
    }

    public ShapefileReader(String shpfile, String dbasefile, String shpfileIndex) {
        this(shpfile, dbasefile);
        this.shapeFileIndex = new File(shpfileIndex);
    }

    public DataSchema schema() {
        return this.schema;
    }

    public ShapefileDescriptor getShapefileDescriptor() {
        return this.shapefileDescriptor;
    }

    public List<DBaseFieldDescriptor> getDatabaseFieldsDescriptors() {
        return this.databaseFieldsDescriptors;
    }

    public File getFileDatabase() {
        return this.databaseFile;
    }

    public File getFileShapefile() {
        return this.shapefile;
    }

    public File getFileShapefileIndex() {
        return this.shapeFileIndex;
    }

    public ShapefileInputStream read() throws IOException {
        ShapefileInputStream is = new ShapefileInputStream(this.shapefile, this.databaseFile, this.shapeFileIndex);
        this.schema = is.schema();
        this.shapefileDescriptor = is.getShapefileDescriptor();
        this.databaseFieldsDescriptors = is.getDatabaseFieldsDescriptors();
        return is;
    }

    public void loadDescriptors() throws IOException {
        ShapefileInputStream is = this.read();
        if (is != null) {
            is.close();
        }
    }
}

