/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.ecere.tile_matrix_set;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ecere.tile_matrix_set.ExtTileMatrixDao;
import mil.nga.geopackage.extension.ecere.tile_matrix_set.ExtTileMatrixSetDao;
import mil.nga.geopackage.extension.ecere.tile_matrix_set.TileMatrixSetTableCreator;
import mil.nga.geopackage.extension.ecere.tile_matrix_set.TileMatrixTablesDao;
import mil.nga.geopackage.extension.ecere.tile_matrix_set.TileMatrixVariableWidthsDao;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;

public class TileMatrixSetExtension
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "ecere";
    public static final String EXTENSION_NAME_NO_AUTHOR = "tms";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("ecere", "tms");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "tms");
    private final ExtTileMatrixDao tileMatrixDao = this.getTileMatrixDao();
    private final ExtTileMatrixSetDao tileMatrixSetDao = this.getTileMatrixSetDao();
    private final TileMatrixTablesDao tileMatrixTablesDao = this.getTileMatrixTablesDao();
    private final TileMatrixVariableWidthsDao tileMatrixVariableWidthsDao = this.getTileMatrixVariableWidthsDao();

    public TileMatrixSetExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    public static String getName() {
        return EXTENSION_NAME;
    }

    public boolean has() {
        return this.has(EXTENSION_NAME, "gpkgext_tile_matrix_tables", null) && this.geoPackage.isTable("gpkgext_tile_matrix_tables");
    }

    public List<Extensions> getOrCreate() {
        this.createTileMatrixSetTables();
        ArrayList<Extensions> extensions = new ArrayList<Extensions>();
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_tile_matrix_tables", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_tile_matrix_variable_widths", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_tile_matrix", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_tile_matrix_set", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkg_tile_matrix_set", null, EXTENSION_DEFINITION, ExtensionScopeType.WRITE_ONLY));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkg_tile_matrix", null, EXTENSION_DEFINITION, ExtensionScopeType.WRITE_ONLY));
        return extensions;
    }

    public void removeExtension() {
        try {
            if (this.has()) {
                this.geoPackage.dropView("gpkg_tile_matrix");
                this.geoPackage.dropView("gpkg_tile_matrix_set");
                this.geoPackage.createTileMatrixTable();
                this.geoPackage.createTileMatrixSetTable();
            }
            if (this.tileMatrixVariableWidthsDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_tile_matrix_variable_widths");
            }
            if (this.tileMatrixTablesDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_tile_matrix_tables");
            }
            if (this.tileMatrixDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_tile_matrix");
            }
            if (this.tileMatrixSetDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_tile_matrix_set");
            }
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
        }
        catch (SQLException exc) {
            throw new GeoPackageException("Failed to delete Tile Matrix Set extension and/or tables. GeoPackage: " + this.geoPackage.getName(), exc);
        }
    }

    public ExtTileMatrixDao getTileMatrixDao() {
        return TileMatrixSetExtension.getTileMatrixDao(this.geoPackage);
    }

    public static ExtTileMatrixDao getTileMatrixDao(GeoPackageCore geoPackage) {
        return ExtTileMatrixDao.create(geoPackage);
    }

    public static ExtTileMatrixDao getTileMatrixDao(GeoPackageCoreConnection db) {
        return ExtTileMatrixDao.create(db);
    }

    public ExtTileMatrixSetDao getTileMatrixSetDao() {
        return TileMatrixSetExtension.getTileMatrixSetDao(this.geoPackage);
    }

    public static ExtTileMatrixSetDao getTileMatrixSetDao(GeoPackageCore geoPackage) {
        return ExtTileMatrixSetDao.create(geoPackage);
    }

    public static ExtTileMatrixSetDao getTileMatrixSetDao(GeoPackageCoreConnection db) {
        return ExtTileMatrixSetDao.create(db);
    }

    public TileMatrixTablesDao getTileMatrixTablesDao() {
        return TileMatrixSetExtension.getTileMatrixTablesDao(this.geoPackage);
    }

    public static TileMatrixTablesDao getTileMatrixTablesDao(GeoPackageCore geoPackage) {
        return TileMatrixTablesDao.create(geoPackage);
    }

    public static TileMatrixTablesDao getTileMatrixTablesDao(GeoPackageCoreConnection db) {
        return TileMatrixTablesDao.create(db);
    }

    public TileMatrixVariableWidthsDao getTileMatrixVariableWidthsDao() {
        return TileMatrixSetExtension.getTileMatrixVariableWidthsDao(this.geoPackage);
    }

    public static TileMatrixVariableWidthsDao getTileMatrixVariableWidthsDao(GeoPackageCore geoPackage) {
        return TileMatrixVariableWidthsDao.create(geoPackage);
    }

    public static TileMatrixVariableWidthsDao getTileMatrixVariableWidthsDao(GeoPackageCoreConnection db) {
        return TileMatrixVariableWidthsDao.create(db);
    }

    public boolean createTileMatrixSetTables() {
        this.verifyWritable();
        boolean created = false;
        TileMatrixSetTableCreator tableCreator = new TileMatrixSetTableCreator(this.geoPackage);
        try {
            if (!this.tileMatrixSetDao.isTableExists()) {
                created = tableCreator.createTileMatrixSet() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_tile_matrix_set table exists and create it", e);
        }
        try {
            if (!this.tileMatrixDao.isTableExists()) {
                created = tableCreator.createTileMatrix() > 0 || created;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_tile_matrix table exists and create it", e);
        }
        try {
            if (!this.tileMatrixTablesDao.isTableExists()) {
                created = tableCreator.createTileMatrixTables() > 0 || created;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_tile_matrix_tables table exists and create it", e);
        }
        try {
            if (!this.tileMatrixVariableWidthsDao.isTableExists()) {
                created = tableCreator.createTileMatrixVariableWidths() > 0 || created;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_tile_matrix_variable_widths table exists and create it", e);
        }
        tableCreator.createScript();
        return created;
    }
}

