/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.crd.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.hugegraph.computer.k8s.crd.model.ComputerJobSpec;
import org.apache.hugegraph.computer.k8s.crd.model.ComputerJobSpecFluent;

public class ComputerJobSpecFluentImpl<A extends ComputerJobSpecFluent<A>>
extends BaseFluent<A>
implements ComputerJobSpecFluent<A> {
    private String algorithmName;
    private Map<String, String> computerConf;
    private Map<String, String> configMapPaths;
    private List<EnvFromSource> envFrom;
    private List<EnvVarBuilder> envVars;
    private String image;
    private String jarFile;
    private String jobId;
    private String jvmOptions;
    private String log4jXml;
    private List<String> masterArgs;
    private List<String> masterCommand;
    private Quantity masterCpu;
    private Quantity masterMemory;
    private PodTemplateSpec podTemplateSpec;
    private String pullPolicy;
    private List<LocalObjectReference> pullSecrets;
    private String remoteJarUri;
    private Map<String, String> secretPaths;
    private SecurityContext securityContext;
    private List<VolumeMountBuilder> volumeMounts;
    private List<VolumeBuilder> volumes;
    private List<String> workerArgs;
    private List<String> workerCommand;
    private Quantity workerCpu;
    private Integer workerInstances;
    private Quantity workerMemory;

    public ComputerJobSpecFluentImpl() {
    }

    public ComputerJobSpecFluentImpl(ComputerJobSpec instance) {
        this.withAlgorithmName(instance.getAlgorithmName());
        this.withComputerConf(instance.getComputerConf());
        this.withConfigMapPaths(instance.getConfigMapPaths());
        this.withEnvFrom(instance.getEnvFrom());
        this.withEnvVars(instance.getEnvVars());
        this.withImage(instance.getImage());
        this.withJarFile(instance.getJarFile());
        this.withJobId(instance.getJobId());
        this.withJvmOptions(instance.getJvmOptions());
        this.withLog4jXml(instance.getLog4jXml());
        this.withMasterArgs(instance.getMasterArgs());
        this.withMasterCommand(instance.getMasterCommand());
        this.withMasterCpu(instance.getMasterCpu());
        this.withMasterMemory(instance.getMasterMemory());
        this.withPodTemplateSpec(instance.getPodTemplateSpec());
        this.withPullPolicy(instance.getPullPolicy());
        this.withPullSecrets(instance.getPullSecrets());
        this.withRemoteJarUri(instance.getRemoteJarUri());
        this.withSecretPaths(instance.getSecretPaths());
        this.withSecurityContext(instance.getSecurityContext());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withVolumes(instance.getVolumes());
        this.withWorkerArgs(instance.getWorkerArgs());
        this.withWorkerCommand(instance.getWorkerCommand());
        this.withWorkerCpu(instance.getWorkerCpu());
        this.withWorkerInstances(instance.getWorkerInstances());
        this.withWorkerMemory(instance.getWorkerMemory());
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public A withAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return (A)this;
    }

    @Override
    public Boolean hasAlgorithmName() {
        return this.algorithmName != null;
    }

    @Override
    @Deprecated
    public A withNewAlgorithmName(String original) {
        return this.withAlgorithmName(new String(original));
    }

    @Override
    public A addToComputerConf(String key, String value) {
        if (this.computerConf == null && key != null && value != null) {
            this.computerConf = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.computerConf.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToComputerConf(Map<String, String> map) {
        if (this.computerConf == null && map != null) {
            this.computerConf = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.computerConf.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromComputerConf(String key) {
        if (this.computerConf == null) {
            return (A)this;
        }
        if (key != null && this.computerConf != null) {
            this.computerConf.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromComputerConf(Map<String, String> map) {
        if (this.computerConf == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.computerConf == null) continue;
                this.computerConf.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getComputerConf() {
        return this.computerConf;
    }

    @Override
    public <K, V> A withComputerConf(Map<String, String> computerConf) {
        this.computerConf = computerConf == null ? null : new LinkedHashMap<String, String>(computerConf);
        return (A)this;
    }

    @Override
    public Boolean hasComputerConf() {
        return this.computerConf != null;
    }

    @Override
    public A addToConfigMapPaths(String key, String value) {
        if (this.configMapPaths == null && key != null && value != null) {
            this.configMapPaths = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.configMapPaths.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfigMapPaths(Map<String, String> map) {
        if (this.configMapPaths == null && map != null) {
            this.configMapPaths = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.configMapPaths.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfigMapPaths(String key) {
        if (this.configMapPaths == null) {
            return (A)this;
        }
        if (key != null && this.configMapPaths != null) {
            this.configMapPaths.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfigMapPaths(Map<String, String> map) {
        if (this.configMapPaths == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.configMapPaths == null) continue;
                this.configMapPaths.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getConfigMapPaths() {
        return this.configMapPaths;
    }

    @Override
    public <K, V> A withConfigMapPaths(Map<String, String> configMapPaths) {
        this.configMapPaths = configMapPaths == null ? null : new LinkedHashMap<String, String>(configMapPaths);
        return (A)this;
    }

    @Override
    public Boolean hasConfigMapPaths() {
        return this.configMapPaths != null;
    }

    @Override
    public A addToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSource>();
        }
        this.envFrom.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSource>();
        }
        this.envFrom.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSource>();
        }
        for (EnvFromSource item : items) {
            this.envFrom.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSource>();
        }
        for (EnvFromSource item : items) {
            this.envFrom.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvFrom(EnvFromSource ... items) {
        for (EnvFromSource item : items) {
            if (this.envFrom == null) continue;
            this.envFrom.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
        for (EnvFromSource item : items) {
            if (this.envFrom == null) continue;
            this.envFrom.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvFromSource> getEnvFrom() {
        return this.envFrom;
    }

    @Override
    public EnvFromSource getEnvFrom(int index) {
        return this.envFrom.get(index);
    }

    @Override
    public EnvFromSource getFirstEnvFrom() {
        return this.envFrom.get(0);
    }

    @Override
    public EnvFromSource getLastEnvFrom() {
        return this.envFrom.get(this.envFrom.size() - 1);
    }

    @Override
    public EnvFromSource getMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
        for (EnvFromSource item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
        for (EnvFromSource item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnvFrom(List<EnvFromSource> envFrom) {
        if (this.envFrom != null) {
            this._visitables.get("envFrom").removeAll(this.envFrom);
        }
        if (envFrom != null) {
            this.envFrom = new ArrayList<EnvFromSource>();
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        } else {
            this.envFrom = null;
        }
        return (A)this;
    }

    @Override
    public A withEnvFrom(EnvFromSource ... envFrom) {
        if (this.envFrom != null) {
            this.envFrom.clear();
        }
        if (envFrom != null) {
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvFrom() {
        return this.envFrom != null && !this.envFrom.isEmpty();
    }

    @Override
    public A addToEnvVars(int index, EnvVar item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.get("envVars").add(index >= 0 ? index : this._visitables.get("envVars").size(), builder);
        this.envVars.add(index >= 0 ? index : this.envVars.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvVars(int index, EnvVar item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.get("envVars").size()) {
            this._visitables.get("envVars").add(builder);
        } else {
            this._visitables.get("envVars").set(index, builder);
        }
        if (index < 0 || index >= this.envVars.size()) {
            this.envVars.add(builder);
        } else {
            this.envVars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvVars(EnvVar ... items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("envVars").add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvVars(Collection<EnvVar> items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("envVars").add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvVars(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("envVars").remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvVars(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("envVars").remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEnvVars(Predicate<EnvVarBuilder> predicate) {
        if (this.envVars == null) {
            return (A)this;
        }
        Iterator<EnvVarBuilder> each = this.envVars.iterator();
        Object visitables = this._visitables.get("envVars");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnvVars() {
        return ComputerJobSpecFluentImpl.build(this.envVars);
    }

    @Override
    public List<EnvVar> buildEnvVars() {
        return ComputerJobSpecFluentImpl.build(this.envVars);
    }

    @Override
    public EnvVar buildEnvVar(int index) {
        return this.envVars.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnvVar() {
        return this.envVars.get(0).build();
    }

    @Override
    public EnvVar buildLastEnvVar() {
        return this.envVars.get(this.envVars.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.envVars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.envVars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnvVars(List<EnvVar> envVars) {
        if (this.envVars != null) {
            this._visitables.get("envVars").removeAll(this.envVars);
        }
        if (envVars != null) {
            this.envVars = new ArrayList<EnvVarBuilder>();
            for (EnvVar item : envVars) {
                this.addToEnvVars(item);
            }
        } else {
            this.envVars = null;
        }
        return (A)this;
    }

    @Override
    public A withEnvVars(EnvVar ... envVars) {
        if (this.envVars != null) {
            this.envVars.clear();
        }
        if (envVars != null) {
            for (EnvVar item : envVars) {
                this.addToEnvVars(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvVars() {
        return this.envVars != null && !this.envVars.isEmpty();
    }

    @Override
    public ComputerJobSpecFluent.EnvVarsNested<A> addNewEnvVar() {
        return new EnvVarsNestedImpl();
    }

    @Override
    public ComputerJobSpecFluent.EnvVarsNested<A> addNewEnvVarLike(EnvVar item) {
        return new EnvVarsNestedImpl(-1, item);
    }

    @Override
    public ComputerJobSpecFluent.EnvVarsNested<A> setNewEnvVarLike(int index, EnvVar item) {
        return new EnvVarsNestedImpl(index, item);
    }

    @Override
    public ComputerJobSpecFluent.EnvVarsNested<A> editEnvVar(int index) {
        if (this.envVars.size() <= index) {
            throw new RuntimeException("Can't edit envVars. Index exceeds size.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public ComputerJobSpecFluent.EnvVarsNested<A> editFirstEnvVar() {
        if (this.envVars.size() == 0) {
            throw new RuntimeException("Can't edit first envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(0, this.buildEnvVar(0));
    }

    @Override
    public ComputerJobSpecFluent.EnvVarsNested<A> editLastEnvVar() {
        int index = this.envVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public ComputerJobSpecFluent.EnvVarsNested<A> editMatchingEnvVar(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envVars.size(); ++i) {
            if (!predicate.test(this.envVars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envVars. No match found.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public A withNewImage(String original) {
        return this.withImage(new String(original));
    }

    @Override
    public String getJarFile() {
        return this.jarFile;
    }

    @Override
    public A withJarFile(String jarFile) {
        this.jarFile = jarFile;
        return (A)this;
    }

    @Override
    public Boolean hasJarFile() {
        return this.jarFile != null;
    }

    @Override
    @Deprecated
    public A withNewJarFile(String original) {
        return this.withJarFile(new String(original));
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public A withJobId(String jobId) {
        this.jobId = jobId;
        return (A)this;
    }

    @Override
    public Boolean hasJobId() {
        return this.jobId != null;
    }

    @Override
    @Deprecated
    public A withNewJobId(String original) {
        return this.withJobId(new String(original));
    }

    @Override
    public String getJvmOptions() {
        return this.jvmOptions;
    }

    @Override
    public A withJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
        return (A)this;
    }

    @Override
    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    @Override
    @Deprecated
    public A withNewJvmOptions(String original) {
        return this.withJvmOptions(new String(original));
    }

    @Override
    public String getLog4jXml() {
        return this.log4jXml;
    }

    @Override
    public A withLog4jXml(String log4jXml) {
        this.log4jXml = log4jXml;
        return (A)this;
    }

    @Override
    public Boolean hasLog4jXml() {
        return this.log4jXml != null;
    }

    @Override
    @Deprecated
    public A withNewLog4jXml(String original) {
        return this.withLog4jXml(new String(original));
    }

    @Override
    public A addToMasterArgs(int index, String item) {
        if (this.masterArgs == null) {
            this.masterArgs = new ArrayList<String>();
        }
        this.masterArgs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMasterArgs(int index, String item) {
        if (this.masterArgs == null) {
            this.masterArgs = new ArrayList<String>();
        }
        this.masterArgs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMasterArgs(String ... items) {
        if (this.masterArgs == null) {
            this.masterArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.masterArgs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMasterArgs(Collection<String> items) {
        if (this.masterArgs == null) {
            this.masterArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.masterArgs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMasterArgs(String ... items) {
        for (String item : items) {
            if (this.masterArgs == null) continue;
            this.masterArgs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMasterArgs(Collection<String> items) {
        for (String item : items) {
            if (this.masterArgs == null) continue;
            this.masterArgs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMasterArgs() {
        return this.masterArgs;
    }

    @Override
    public String getMasterArg(int index) {
        return this.masterArgs.get(index);
    }

    @Override
    public String getFirstMasterArg() {
        return this.masterArgs.get(0);
    }

    @Override
    public String getLastMasterArg() {
        return this.masterArgs.get(this.masterArgs.size() - 1);
    }

    @Override
    public String getMatchingMasterArg(Predicate<String> predicate) {
        for (String item : this.masterArgs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMasterArg(Predicate<String> predicate) {
        for (String item : this.masterArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMasterArgs(List<String> masterArgs) {
        if (this.masterArgs != null) {
            this._visitables.get("masterArgs").removeAll(this.masterArgs);
        }
        if (masterArgs != null) {
            this.masterArgs = new ArrayList<String>();
            for (String item : masterArgs) {
                this.addToMasterArgs(item);
            }
        } else {
            this.masterArgs = null;
        }
        return (A)this;
    }

    @Override
    public A withMasterArgs(String ... masterArgs) {
        if (this.masterArgs != null) {
            this.masterArgs.clear();
        }
        if (masterArgs != null) {
            for (String item : masterArgs) {
                this.addToMasterArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMasterArgs() {
        return this.masterArgs != null && !this.masterArgs.isEmpty();
    }

    @Override
    public A addNewMasterArg(String original) {
        return this.addToMasterArgs(new String(original));
    }

    @Override
    public A addToMasterCommand(int index, String item) {
        if (this.masterCommand == null) {
            this.masterCommand = new ArrayList<String>();
        }
        this.masterCommand.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMasterCommand(int index, String item) {
        if (this.masterCommand == null) {
            this.masterCommand = new ArrayList<String>();
        }
        this.masterCommand.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMasterCommand(String ... items) {
        if (this.masterCommand == null) {
            this.masterCommand = new ArrayList<String>();
        }
        for (String item : items) {
            this.masterCommand.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMasterCommand(Collection<String> items) {
        if (this.masterCommand == null) {
            this.masterCommand = new ArrayList<String>();
        }
        for (String item : items) {
            this.masterCommand.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMasterCommand(String ... items) {
        for (String item : items) {
            if (this.masterCommand == null) continue;
            this.masterCommand.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMasterCommand(Collection<String> items) {
        for (String item : items) {
            if (this.masterCommand == null) continue;
            this.masterCommand.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMasterCommand() {
        return this.masterCommand;
    }

    @Override
    public String getMasterCommand(int index) {
        return this.masterCommand.get(index);
    }

    @Override
    public String getFirstMasterCommand() {
        return this.masterCommand.get(0);
    }

    @Override
    public String getLastMasterCommand() {
        return this.masterCommand.get(this.masterCommand.size() - 1);
    }

    @Override
    public String getMatchingMasterCommand(Predicate<String> predicate) {
        for (String item : this.masterCommand) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMasterCommand(Predicate<String> predicate) {
        for (String item : this.masterCommand) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMasterCommand(List<String> masterCommand) {
        if (this.masterCommand != null) {
            this._visitables.get("masterCommand").removeAll(this.masterCommand);
        }
        if (masterCommand != null) {
            this.masterCommand = new ArrayList<String>();
            for (String item : masterCommand) {
                this.addToMasterCommand(item);
            }
        } else {
            this.masterCommand = null;
        }
        return (A)this;
    }

    @Override
    public A withMasterCommand(String ... masterCommand) {
        if (this.masterCommand != null) {
            this.masterCommand.clear();
        }
        if (masterCommand != null) {
            for (String item : masterCommand) {
                this.addToMasterCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMasterCommand() {
        return this.masterCommand != null && !this.masterCommand.isEmpty();
    }

    @Override
    public A addNewMasterCommand(String original) {
        return this.addToMasterCommand(new String(original));
    }

    @Override
    public Quantity getMasterCpu() {
        return this.masterCpu;
    }

    @Override
    public A withMasterCpu(Quantity masterCpu) {
        this.masterCpu = masterCpu;
        return (A)this;
    }

    @Override
    public Boolean hasMasterCpu() {
        return this.masterCpu != null;
    }

    @Override
    public A withNewMasterCpu(String amount, String format) {
        return this.withMasterCpu(new Quantity(amount, format));
    }

    @Override
    public A withNewMasterCpu(String amount) {
        return this.withMasterCpu(new Quantity(amount));
    }

    @Override
    public Quantity getMasterMemory() {
        return this.masterMemory;
    }

    @Override
    public A withMasterMemory(Quantity masterMemory) {
        this.masterMemory = masterMemory;
        return (A)this;
    }

    @Override
    public Boolean hasMasterMemory() {
        return this.masterMemory != null;
    }

    @Override
    public A withNewMasterMemory(String amount, String format) {
        return this.withMasterMemory(new Quantity(amount, format));
    }

    @Override
    public A withNewMasterMemory(String amount) {
        return this.withMasterMemory(new Quantity(amount));
    }

    @Override
    public PodTemplateSpec getPodTemplateSpec() {
        return this.podTemplateSpec;
    }

    @Override
    public A withPodTemplateSpec(PodTemplateSpec podTemplateSpec) {
        this.podTemplateSpec = podTemplateSpec;
        return (A)this;
    }

    @Override
    public Boolean hasPodTemplateSpec() {
        return this.podTemplateSpec != null;
    }

    @Override
    public String getPullPolicy() {
        return this.pullPolicy;
    }

    @Override
    public A withPullPolicy(String pullPolicy) {
        this.pullPolicy = pullPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPullPolicy() {
        return this.pullPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewPullPolicy(String original) {
        return this.withPullPolicy(new String(original));
    }

    @Override
    public A addToPullSecrets(int index, LocalObjectReference item) {
        if (this.pullSecrets == null) {
            this.pullSecrets = new ArrayList<LocalObjectReference>();
        }
        this.pullSecrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPullSecrets(int index, LocalObjectReference item) {
        if (this.pullSecrets == null) {
            this.pullSecrets = new ArrayList<LocalObjectReference>();
        }
        this.pullSecrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPullSecrets(LocalObjectReference ... items) {
        if (this.pullSecrets == null) {
            this.pullSecrets = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.pullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPullSecrets(Collection<LocalObjectReference> items) {
        if (this.pullSecrets == null) {
            this.pullSecrets = new ArrayList<LocalObjectReference>();
        }
        for (LocalObjectReference item : items) {
            this.pullSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            if (this.pullSecrets == null) continue;
            this.pullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            if (this.pullSecrets == null) continue;
            this.pullSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<LocalObjectReference> getPullSecrets() {
        return this.pullSecrets;
    }

    @Override
    public LocalObjectReference getPullSecret(int index) {
        return this.pullSecrets.get(index);
    }

    @Override
    public LocalObjectReference getFirstPullSecret() {
        return this.pullSecrets.get(0);
    }

    @Override
    public LocalObjectReference getLastPullSecret() {
        return this.pullSecrets.get(this.pullSecrets.size() - 1);
    }

    @Override
    public LocalObjectReference getMatchingPullSecret(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.pullSecrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPullSecret(Predicate<LocalObjectReference> predicate) {
        for (LocalObjectReference item : this.pullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPullSecrets(List<LocalObjectReference> pullSecrets) {
        if (this.pullSecrets != null) {
            this._visitables.get("pullSecrets").removeAll(this.pullSecrets);
        }
        if (pullSecrets != null) {
            this.pullSecrets = new ArrayList<LocalObjectReference>();
            for (LocalObjectReference item : pullSecrets) {
                this.addToPullSecrets(item);
            }
        } else {
            this.pullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withPullSecrets(LocalObjectReference ... pullSecrets) {
        if (this.pullSecrets != null) {
            this.pullSecrets.clear();
        }
        if (pullSecrets != null) {
            for (LocalObjectReference item : pullSecrets) {
                this.addToPullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecrets() {
        return this.pullSecrets != null && !this.pullSecrets.isEmpty();
    }

    @Override
    public A addNewPullSecret(String name) {
        return this.addToPullSecrets(new LocalObjectReference(name));
    }

    @Override
    public String getRemoteJarUri() {
        return this.remoteJarUri;
    }

    @Override
    public A withRemoteJarUri(String remoteJarUri) {
        this.remoteJarUri = remoteJarUri;
        return (A)this;
    }

    @Override
    public Boolean hasRemoteJarUri() {
        return this.remoteJarUri != null;
    }

    @Override
    @Deprecated
    public A withNewRemoteJarUri(String original) {
        return this.withRemoteJarUri(new String(original));
    }

    @Override
    public A addToSecretPaths(String key, String value) {
        if (this.secretPaths == null && key != null && value != null) {
            this.secretPaths = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.secretPaths.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSecretPaths(Map<String, String> map) {
        if (this.secretPaths == null && map != null) {
            this.secretPaths = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.secretPaths.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecretPaths(String key) {
        if (this.secretPaths == null) {
            return (A)this;
        }
        if (key != null && this.secretPaths != null) {
            this.secretPaths.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecretPaths(Map<String, String> map) {
        if (this.secretPaths == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.secretPaths == null) continue;
                this.secretPaths.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSecretPaths() {
        return this.secretPaths;
    }

    @Override
    public <K, V> A withSecretPaths(Map<String, String> secretPaths) {
        this.secretPaths = secretPaths == null ? null : new LinkedHashMap<String, String>(secretPaths);
        return (A)this;
    }

    @Override
    public Boolean hasSecretPaths() {
        return this.secretPaths != null;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public A withSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        this._visitables.get("volumeMounts").add(index >= 0 ? index : this._visitables.get("volumeMounts").size(), builder);
        this.volumeMounts.add(index >= 0 ? index : this.volumeMounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeMounts").size()) {
            this._visitables.get("volumeMounts").add(builder);
        } else {
            this._visitables.get("volumeMounts").set(index, builder);
        }
        if (index < 0 || index >= this.volumeMounts.size()) {
            this.volumeMounts.add(builder);
        } else {
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        Iterator<VolumeMountBuilder> each = this.volumeMounts.iterator();
        Object visitables = this._visitables.get("volumeMounts");
        while (each.hasNext()) {
            VolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VolumeMount> getVolumeMounts() {
        return ComputerJobSpecFluentImpl.build(this.volumeMounts);
    }

    @Override
    public List<VolumeMount> buildVolumeMounts() {
        return ComputerJobSpecFluentImpl.build(this.volumeMounts);
    }

    @Override
    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    @Override
    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    @Override
    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    @Override
    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get("volumeMounts").removeAll(this.volumeMounts);
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public ComputerJobSpecFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    @Override
    public ComputerJobSpecFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    @Override
    public ComputerJobSpecFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    @Override
    public ComputerJobSpecFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public ComputerJobSpecFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    @Override
    public ComputerJobSpecFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public ComputerJobSpecFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get("volumes").add(index >= 0 ? index : this._visitables.get("volumes").size(), builder);
        this.volumes.add(index >= 0 ? index : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumes").size()) {
            this._visitables.get("volumes").add(builder);
        } else {
            this._visitables.get("volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        Object visitables = this._visitables.get("volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return ComputerJobSpecFluentImpl.build(this.volumes);
    }

    @Override
    public List<Volume> buildVolumes() {
        return ComputerJobSpecFluentImpl.build(this.volumes);
    }

    @Override
    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<VolumeBuilder>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public ComputerJobSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public ComputerJobSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public ComputerJobSpecFluent.VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public ComputerJobSpecFluent.VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public ComputerJobSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public ComputerJobSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public ComputerJobSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public A addToWorkerArgs(int index, String item) {
        if (this.workerArgs == null) {
            this.workerArgs = new ArrayList<String>();
        }
        this.workerArgs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToWorkerArgs(int index, String item) {
        if (this.workerArgs == null) {
            this.workerArgs = new ArrayList<String>();
        }
        this.workerArgs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToWorkerArgs(String ... items) {
        if (this.workerArgs == null) {
            this.workerArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.workerArgs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToWorkerArgs(Collection<String> items) {
        if (this.workerArgs == null) {
            this.workerArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.workerArgs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromWorkerArgs(String ... items) {
        for (String item : items) {
            if (this.workerArgs == null) continue;
            this.workerArgs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWorkerArgs(Collection<String> items) {
        for (String item : items) {
            if (this.workerArgs == null) continue;
            this.workerArgs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getWorkerArgs() {
        return this.workerArgs;
    }

    @Override
    public String getWorkerArg(int index) {
        return this.workerArgs.get(index);
    }

    @Override
    public String getFirstWorkerArg() {
        return this.workerArgs.get(0);
    }

    @Override
    public String getLastWorkerArg() {
        return this.workerArgs.get(this.workerArgs.size() - 1);
    }

    @Override
    public String getMatchingWorkerArg(Predicate<String> predicate) {
        for (String item : this.workerArgs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWorkerArg(Predicate<String> predicate) {
        for (String item : this.workerArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWorkerArgs(List<String> workerArgs) {
        if (this.workerArgs != null) {
            this._visitables.get("workerArgs").removeAll(this.workerArgs);
        }
        if (workerArgs != null) {
            this.workerArgs = new ArrayList<String>();
            for (String item : workerArgs) {
                this.addToWorkerArgs(item);
            }
        } else {
            this.workerArgs = null;
        }
        return (A)this;
    }

    @Override
    public A withWorkerArgs(String ... workerArgs) {
        if (this.workerArgs != null) {
            this.workerArgs.clear();
        }
        if (workerArgs != null) {
            for (String item : workerArgs) {
                this.addToWorkerArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWorkerArgs() {
        return this.workerArgs != null && !this.workerArgs.isEmpty();
    }

    @Override
    public A addNewWorkerArg(String original) {
        return this.addToWorkerArgs(new String(original));
    }

    @Override
    public A addToWorkerCommand(int index, String item) {
        if (this.workerCommand == null) {
            this.workerCommand = new ArrayList<String>();
        }
        this.workerCommand.add(index, item);
        return (A)this;
    }

    @Override
    public A setToWorkerCommand(int index, String item) {
        if (this.workerCommand == null) {
            this.workerCommand = new ArrayList<String>();
        }
        this.workerCommand.set(index, item);
        return (A)this;
    }

    @Override
    public A addToWorkerCommand(String ... items) {
        if (this.workerCommand == null) {
            this.workerCommand = new ArrayList<String>();
        }
        for (String item : items) {
            this.workerCommand.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToWorkerCommand(Collection<String> items) {
        if (this.workerCommand == null) {
            this.workerCommand = new ArrayList<String>();
        }
        for (String item : items) {
            this.workerCommand.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromWorkerCommand(String ... items) {
        for (String item : items) {
            if (this.workerCommand == null) continue;
            this.workerCommand.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWorkerCommand(Collection<String> items) {
        for (String item : items) {
            if (this.workerCommand == null) continue;
            this.workerCommand.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getWorkerCommand() {
        return this.workerCommand;
    }

    @Override
    public String getWorkerCommand(int index) {
        return this.workerCommand.get(index);
    }

    @Override
    public String getFirstWorkerCommand() {
        return this.workerCommand.get(0);
    }

    @Override
    public String getLastWorkerCommand() {
        return this.workerCommand.get(this.workerCommand.size() - 1);
    }

    @Override
    public String getMatchingWorkerCommand(Predicate<String> predicate) {
        for (String item : this.workerCommand) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWorkerCommand(Predicate<String> predicate) {
        for (String item : this.workerCommand) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWorkerCommand(List<String> workerCommand) {
        if (this.workerCommand != null) {
            this._visitables.get("workerCommand").removeAll(this.workerCommand);
        }
        if (workerCommand != null) {
            this.workerCommand = new ArrayList<String>();
            for (String item : workerCommand) {
                this.addToWorkerCommand(item);
            }
        } else {
            this.workerCommand = null;
        }
        return (A)this;
    }

    @Override
    public A withWorkerCommand(String ... workerCommand) {
        if (this.workerCommand != null) {
            this.workerCommand.clear();
        }
        if (workerCommand != null) {
            for (String item : workerCommand) {
                this.addToWorkerCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWorkerCommand() {
        return this.workerCommand != null && !this.workerCommand.isEmpty();
    }

    @Override
    public A addNewWorkerCommand(String original) {
        return this.addToWorkerCommand(new String(original));
    }

    @Override
    public Quantity getWorkerCpu() {
        return this.workerCpu;
    }

    @Override
    public A withWorkerCpu(Quantity workerCpu) {
        this.workerCpu = workerCpu;
        return (A)this;
    }

    @Override
    public Boolean hasWorkerCpu() {
        return this.workerCpu != null;
    }

    @Override
    public A withNewWorkerCpu(String amount, String format) {
        return this.withWorkerCpu(new Quantity(amount, format));
    }

    @Override
    public A withNewWorkerCpu(String amount) {
        return this.withWorkerCpu(new Quantity(amount));
    }

    @Override
    public Integer getWorkerInstances() {
        return this.workerInstances;
    }

    @Override
    public A withWorkerInstances(Integer workerInstances) {
        this.workerInstances = workerInstances;
        return (A)this;
    }

    @Override
    public Boolean hasWorkerInstances() {
        return this.workerInstances != null;
    }

    @Override
    public Quantity getWorkerMemory() {
        return this.workerMemory;
    }

    @Override
    public A withWorkerMemory(Quantity workerMemory) {
        this.workerMemory = workerMemory;
        return (A)this;
    }

    @Override
    public Boolean hasWorkerMemory() {
        return this.workerMemory != null;
    }

    @Override
    public A withNewWorkerMemory(String amount, String format) {
        return this.withWorkerMemory(new Quantity(amount, format));
    }

    @Override
    public A withNewWorkerMemory(String amount) {
        return this.withWorkerMemory(new Quantity(amount));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputerJobSpecFluentImpl that = (ComputerJobSpecFluentImpl)o;
        if (this.algorithmName != null ? !this.algorithmName.equals(that.algorithmName) : that.algorithmName != null) {
            return false;
        }
        if (this.computerConf != null ? !this.computerConf.equals(that.computerConf) : that.computerConf != null) {
            return false;
        }
        if (this.configMapPaths != null ? !this.configMapPaths.equals(that.configMapPaths) : that.configMapPaths != null) {
            return false;
        }
        if (this.envFrom != null ? !this.envFrom.equals(that.envFrom) : that.envFrom != null) {
            return false;
        }
        if (this.envVars != null ? !this.envVars.equals(that.envVars) : that.envVars != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.jarFile != null ? !this.jarFile.equals(that.jarFile) : that.jarFile != null) {
            return false;
        }
        if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
            return false;
        }
        if (this.jvmOptions != null ? !this.jvmOptions.equals(that.jvmOptions) : that.jvmOptions != null) {
            return false;
        }
        if (this.log4jXml != null ? !this.log4jXml.equals(that.log4jXml) : that.log4jXml != null) {
            return false;
        }
        if (this.masterArgs != null ? !this.masterArgs.equals(that.masterArgs) : that.masterArgs != null) {
            return false;
        }
        if (this.masterCommand != null ? !this.masterCommand.equals(that.masterCommand) : that.masterCommand != null) {
            return false;
        }
        if (this.masterCpu != null ? !this.masterCpu.equals(that.masterCpu) : that.masterCpu != null) {
            return false;
        }
        if (this.masterMemory != null ? !this.masterMemory.equals(that.masterMemory) : that.masterMemory != null) {
            return false;
        }
        if (this.podTemplateSpec != null ? !this.podTemplateSpec.equals(that.podTemplateSpec) : that.podTemplateSpec != null) {
            return false;
        }
        if (this.pullPolicy != null ? !this.pullPolicy.equals(that.pullPolicy) : that.pullPolicy != null) {
            return false;
        }
        if (this.pullSecrets != null ? !this.pullSecrets.equals(that.pullSecrets) : that.pullSecrets != null) {
            return false;
        }
        if (this.remoteJarUri != null ? !this.remoteJarUri.equals(that.remoteJarUri) : that.remoteJarUri != null) {
            return false;
        }
        if (this.secretPaths != null ? !this.secretPaths.equals(that.secretPaths) : that.secretPaths != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        if (this.workerArgs != null ? !this.workerArgs.equals(that.workerArgs) : that.workerArgs != null) {
            return false;
        }
        if (this.workerCommand != null ? !this.workerCommand.equals(that.workerCommand) : that.workerCommand != null) {
            return false;
        }
        if (this.workerCpu != null ? !this.workerCpu.equals(that.workerCpu) : that.workerCpu != null) {
            return false;
        }
        if (this.workerInstances != null ? !this.workerInstances.equals(that.workerInstances) : that.workerInstances != null) {
            return false;
        }
        return !(this.workerMemory != null ? !this.workerMemory.equals(that.workerMemory) : that.workerMemory != null);
    }

    public int hashCode() {
        return Objects.hash(this.algorithmName, this.computerConf, this.configMapPaths, this.envFrom, this.envVars, this.image, this.jarFile, this.jobId, this.jvmOptions, this.log4jXml, this.masterArgs, this.masterCommand, this.masterCpu, this.masterMemory, this.podTemplateSpec, this.pullPolicy, this.pullSecrets, this.remoteJarUri, this.secretPaths, this.securityContext, this.volumeMounts, this.volumes, this.workerArgs, this.workerCommand, this.workerCpu, this.workerInstances, this.workerMemory, super.hashCode());
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<ComputerJobSpecFluent.VolumesNested<N>>
    implements ComputerJobSpecFluent.VolumesNested<N>,
    Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

        VolumesNestedImpl(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComputerJobSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class VolumeMountsNestedImpl<N>
    extends VolumeMountFluentImpl<ComputerJobSpecFluent.VolumeMountsNested<N>>
    implements ComputerJobSpecFluent.VolumeMountsNested<N>,
    Nested<N> {
        private final VolumeMountBuilder builder;
        private final int index;

        VolumeMountsNestedImpl(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder(this, item);
        }

        VolumeMountsNestedImpl() {
            this.index = -1;
            this.builder = new VolumeMountBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComputerJobSpecFluentImpl.this.setToVolumeMounts(this.index, this.builder.build());
        }

        @Override
        public N endVolumeMount() {
            return this.and();
        }
    }

    public class EnvVarsNestedImpl<N>
    extends EnvVarFluentImpl<ComputerJobSpecFluent.EnvVarsNested<N>>
    implements ComputerJobSpecFluent.EnvVarsNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvVarsNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvVarsNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComputerJobSpecFluentImpl.this.setToEnvVars(this.index, this.builder.build());
        }

        @Override
        public N endEnvVar() {
            return this.and();
        }
    }
}

