/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.observation.MetricConfig;
import org.apache.hc.client5.http.observation.ObservingOptions;
import org.apache.hc.core5.util.Args;

public final class MeteredDnsResolver
implements DnsResolver {
    private final DnsResolver delegate;
    private final MeterRegistry registry;
    private final MetricConfig mc;
    private final ObservingOptions opts;

    public MeteredDnsResolver(DnsResolver delegate, MeterRegistry registry, MetricConfig mc, ObservingOptions opts) {
        this.delegate = (DnsResolver)Args.notNull((Object)delegate, (String)"delegate");
        this.registry = (MeterRegistry)Args.notNull((Object)registry, (String)"registry");
        this.mc = mc != null ? mc : MetricConfig.builder().build();
        this.opts = opts != null ? opts : ObservingOptions.DEFAULT;
    }

    private List<Tag> tags(String result, String host) {
        ArrayList<Tag> ts = new ArrayList<Tag>(2);
        ts.add(Tag.of((String)"result", (String)result));
        if (this.opts.tagLevel == ObservingOptions.TagLevel.EXTENDED && host != null) {
            ts.add(Tag.of((String)"host", (String)host));
        }
        if (!this.mc.commonTags.isEmpty()) {
            ts.addAll(this.mc.commonTags);
        }
        return ts;
    }

    public InetAddress[] resolve(String host) throws UnknownHostException {
        long t0 = System.nanoTime();
        try {
            InetAddress[] out = this.delegate.resolve(host);
            List<Tag> t = this.tags("ok", host);
            Timer.builder((String)(this.mc.prefix + ".dns.resolve")).tags(t).register(this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
            Counter.builder((String)(this.mc.prefix + ".dns.resolutions")).tags(t).register(this.registry).increment();
            return out;
        }
        catch (UnknownHostException ex) {
            List<Tag> t = this.tags("error", host);
            Timer.builder((String)(this.mc.prefix + ".dns.resolve")).tags(t).register(this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
            Counter.builder((String)(this.mc.prefix + ".dns.resolutions")).tags(t).register(this.registry).increment();
            throw ex;
        }
    }

    public String resolveCanonicalHostname(String host) throws UnknownHostException {
        long t0 = System.nanoTime();
        try {
            String out = this.delegate.resolveCanonicalHostname(host);
            List<Tag> t = this.tags("ok", host);
            Timer.builder((String)(this.mc.prefix + ".dns.canonical")).tags(t).register(this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
            Counter.builder((String)(this.mc.prefix + ".dns.canonicals")).tags(t).register(this.registry).increment();
            return out;
        }
        catch (UnknownHostException ex) {
            List<Tag> t = this.tags("error", host);
            Timer.builder((String)(this.mc.prefix + ".dns.canonical")).tags(t).register(this.registry).record(System.nanoTime() - t0, TimeUnit.NANOSECONDS);
            Counter.builder((String)(this.mc.prefix + ".dns.canonicals")).tags(t).register(this.registry).increment();
            throw ex;
        }
    }
}

