set hive.mapred.mode=nonstrict;
-- This test verifies that a table partition could be dropped with columns stats computed
-- The column stats for a partitioned table will go to PART_COL_STATS
CREATE DATABASE IF NOT EXISTS partstatsdb1;
USE partstatsdb1;
CREATE TABLE IF NOT EXISTS testtable_n0 (key STRING, value STRING) PARTITIONED BY (part1 STRING, Part2 STRING);
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE testtable_n0 PARTITION (part1='p11', Part2='P12');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE testtable_n0 PARTITION (part1='p21', Part2='P22');
ANALYZE TABLE testtable_n0 COMPUTE STATISTICS FOR COLUMNS key;
ANALYZE TABLE testtable_n0 PARTITION (part1='p11', Part2='P12') COMPUTE STATISTICS FOR COLUMNS key;


CREATE TABLE IF NOT EXISTS TestTable1_n1 (key STRING, value STRING) PARTITIONED BY (part1 STRING, Part2 STRING);
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TestTable1_n1 PARTITION (part1='p11', Part2='P11');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TestTable1_n1 PARTITION (part1='p11', Part2='P12');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TestTable1_n1 PARTITION (part1='p21', Part2='P22');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TestTable1_n1 PARTITION (part1='p31', Part2='P32');
ANALYZE TABLE TestTable1_n1 COMPUTE STATISTICS FOR COLUMNS key;
ANALYZE TABLE TestTable1_n1 PARTITION (part1='p11') COMPUTE STATISTICS FOR COLUMNS key;
ANALYZE TABLE TestTable1_n1 PARTITION (part1='p11', Part2='P12') COMPUTE STATISTICS FOR COLUMNS key;

CREATE TABLE IF NOT EXISTS TESTTABLE2_n1 (key STRING, value STRING) PARTITIONED BY (part1 STRING, Part2 STRING);
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TESTTABLE2_n1 PARTITION (part1='p11', Part2='P12');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TESTTABLE2_n1 PARTITION (part1='p21', Part2='P22');
ANALYZE TABLE TESTTABLE2_n1 COMPUTE STATISTICS FOR COLUMNS key;
ANALYZE TABLE TESTTABLE2_n1 PARTITION (part1='p11', Part2='P12') COMPUTE STATISTICS FOR COLUMNS key;

ALTER TABLE partstatsdb1.testtable_n0 DROP PARTITION (part1='p11', Part2='P12');
ALTER TABLE partstatsdb1.TestTable1_n1 DROP PARTITION (part1='p11', Part2='P12');
ALTER TABLE partstatsdb1.TESTTABLE2_n1 DROP PARTITION (part1='p11', Part2='P12');

DROP TABLE partstatsdb1.testtable_n0;
DROP TABLE partstatsdb1.TestTable1_n1;
DROP TABLE partstatsdb1.TESTTABLE2_n1;
DROP DATABASE partstatsdb1;

CREATE DATABASE IF NOT EXISTS PARTSTATSDB2;
USE PARTSTATSDB2;
CREATE TABLE IF NOT EXISTS testtable_n0 (key STRING, value STRING) PARTITIONED BY (part1 STRING, Part2 STRING);
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE testtable_n0 PARTITION (part1='p11', Part2='P12');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE testtable_n0 PARTITION (part1='p21', Part2='P22');
ANALYZE TABLE testtable_n0 COMPUTE STATISTICS FOR COLUMNS key;
ANALYZE TABLE testtable_n0 PARTITION (part1='p11', Part2='P12') COMPUTE STATISTICS FOR COLUMNS key;


CREATE TABLE IF NOT EXISTS TestTable1_n1 (key STRING, value STRING) PARTITIONED BY (part1 STRING, Part2 STRING);
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TestTable1_n1 PARTITION (part1='p11', Part2='P11');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TestTable1_n1 PARTITION (part1='p11', Part2='P12');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TestTable1_n1 PARTITION (part1='p21', Part2='P22');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TestTable1_n1 PARTITION (part1='p31', Part2='P32');
ANALYZE TABLE TestTable1_n1 COMPUTE STATISTICS FOR COLUMNS key;
ANALYZE TABLE TestTable1_n1 PARTITION (part1='p11') COMPUTE STATISTICS FOR COLUMNS key;
ANALYZE TABLE TestTable1_n1 PARTITION (part1='p11', Part2='P12') COMPUTE STATISTICS FOR COLUMNS key;

CREATE TABLE IF NOT EXISTS TESTTABLE2_n1 (key STRING, value STRING) PARTITIONED BY (part1 STRING, Part2 STRING);
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TESTTABLE2_n1 PARTITION (part1='p11', Part2='P12');
LOAD DATA LOCAL INPATH '../../data/files/kv1.txt' OVERWRITE INTO TABLE TESTTABLE2_n1 PARTITION (part1='p21', Part2='P22');
ANALYZE TABLE TESTTABLE2_n1 COMPUTE STATISTICS FOR COLUMNS key;
ANALYZE TABLE TESTTABLE2_n1 PARTITION (part1='p11', Part2='P12') COMPUTE STATISTICS FOR COLUMNS key;

ALTER TABLE PARTSTATSDB2.testtable_n0 DROP PARTITION (part1='p11', Part2='P12');
ALTER TABLE PARTSTATSDB2.TestTable1_n1 DROP PARTITION (part1='p11', Part2='P12');
ALTER TABLE PARTSTATSDB2.TESTTABLE2_n1 DROP PARTITION (part1='p11', Part2='P12');

DROP TABLE PARTSTATSDB2.testtable_n0;
DROP TABLE PARTSTATSDB2.TestTable1_n1;
DROP TABLE PARTSTATSDB2.TESTTABLE2_n1;
DROP DATABASE PARTSTATSDB2;

