/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public final class LeaderStandbySMD
extends StateModelDefinition {
    public static final String name = "LeaderStandby";

    public LeaderStandbySMD() {
        super(LeaderStandbySMD.generateConfigForLeaderStandby());
    }

    public static StateModelDefinition build() {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder(name);
        builder.initialState(States.OFFLINE.name());
        builder.addState(States.LEADER.name(), 0);
        builder.addState(States.STANDBY.name(), 1);
        builder.addState(States.OFFLINE.name(), 2);
        for (HelixDefinedState state : HelixDefinedState.values()) {
            builder.addState(state.name());
        }
        builder.addTransition(States.LEADER.name(), States.STANDBY.name(), 0);
        builder.addTransition(States.STANDBY.name(), States.LEADER.name(), 1);
        builder.addTransition(States.OFFLINE.name(), States.STANDBY.name(), 2);
        builder.addTransition(States.STANDBY.name(), States.OFFLINE.name(), 3);
        builder.addTransition(States.OFFLINE.name(), HelixDefinedState.DROPPED.name());
        builder.upperBound(States.LEADER.name(), 1);
        builder.dynamicUpperBound(States.STANDBY.name(), "R");
        return builder.build();
    }

    @Deprecated
    public static ZNRecord generateConfigForLeaderStandby() {
        HashMap<String, String> metadata;
        String key;
        ZNRecord record = new ZNRecord(name);
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), "OFFLINE");
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add("LEADER");
        statePriorityList.add("STANDBY");
        statePriorityList.add("OFFLINE");
        statePriorityList.add("DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            key = state + ".meta";
            metadata = new HashMap<String, String>();
            if (state.equals("LEADER")) {
                metadata.put("count", "1");
                record.setMapField(key, metadata);
            }
            if (state.equals("STANDBY")) {
                metadata.put("count", "R");
                record.setMapField(key, metadata);
            }
            if (state.equals("OFFLINE")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
            }
            if (!state.equals("DROPPED")) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        for (String state : statePriorityList) {
            key = state + ".next";
            if (state.equals("LEADER")) {
                metadata = new HashMap();
                metadata.put("STANDBY", "STANDBY");
                metadata.put("OFFLINE", "STANDBY");
                metadata.put("DROPPED", "STANDBY");
                record.setMapField(key, metadata);
            }
            if (state.equals("STANDBY")) {
                metadata = new HashMap();
                metadata.put("LEADER", "LEADER");
                metadata.put("OFFLINE", "OFFLINE");
                metadata.put("DROPPED", "OFFLINE");
                record.setMapField(key, metadata);
            }
            if (!state.equals("OFFLINE")) continue;
            metadata = new HashMap();
            metadata.put("STANDBY", "STANDBY");
            metadata.put("LEADER", "STANDBY");
            metadata.put("DROPPED", "DROPPED");
            record.setMapField(key, metadata);
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("LEADER-STANDBY");
        stateTransitionPriorityList.add("STANDBY-LEADER");
        stateTransitionPriorityList.add("OFFLINE-STANDBY");
        stateTransitionPriorityList.add("STANDBY-OFFLINE");
        stateTransitionPriorityList.add("OFFLINE-DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }

    public static enum States {
        LEADER,
        STANDBY,
        OFFLINE;

    }
}

