/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class ExternalView
extends HelixProperty {
    public ExternalView(String resource) {
        super(new ZNRecord(resource));
    }

    public ExternalView(ZNRecord record) {
        super(record);
    }

    public void setState(String partition, String instance, String state) {
        if (this._record.getMapField(partition) == null) {
            this._record.setMapField(partition, new TreeMap<String, String>());
        }
        this._record.getMapField(partition).put(instance, state);
    }

    public void setStateMap(String partitionName, Map<String, String> currentStateMap) {
        this._record.setMapField(partitionName, currentStateMap);
    }

    public Set<String> getPartitionSet() {
        return this._record.getMapFields().keySet();
    }

    public Map<String, String> getStateMap(String partitionName) {
        return this._record.getMapField(partitionName);
    }

    public String getResourceName() {
        return this._record.getId();
    }

    public String getResourceGroupName() {
        return this._record.getSimpleField(ExternalViewProperty.RESOURCE_GROUP_NAME.toString());
    }

    public boolean isGroupRoutingEnabled() {
        return this._record.getBooleanField(ExternalViewProperty.GROUP_ROUTING_ENABLED.name(), false);
    }

    public String getInstanceGroupTag() {
        return this._record.getSimpleField(ExternalViewProperty.INSTANCE_GROUP_TAG.toString());
    }

    public int getMinActiveReplicas() {
        return this._record.getIntField(ExternalViewProperty.MIN_ACTIVE_REPLICAS.toString(), -1);
    }

    public String getStateModelDefRef() {
        return this._record.getSimpleField(ExternalViewProperty.STATE_MODEL_DEF_REF.toString());
    }

    public String getReplicas() {
        return this._record.getSimpleField(ExternalViewProperty.REPLICAS.name());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static enum ExternalViewProperty {
        INSTANCE_GROUP_TAG,
        RESOURCE_GROUP_NAME,
        GROUP_ROUTING_ENABLED,
        MIN_ACTIVE_REPLICAS,
        STATE_MODEL_DEF_REF,
        REPLICAS;

    }
}

