/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy.crushMapping;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.rebalancer.topology.Node;
import org.apache.helix.util.JenkinsHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRUSHPlacementAlgorithm {
    private static final int MAX_LOOPBACK_COUNT = 50;
    private static final Logger logger = LoggerFactory.getLogger(CRUSHPlacementAlgorithm.class);
    private final boolean keepOffset;
    private final Map<Long, Integer> roundOffset;

    public CRUSHPlacementAlgorithm() {
        this(false);
    }

    public CRUSHPlacementAlgorithm(boolean keepOffset) {
        this.keepOffset = keepOffset;
        this.roundOffset = keepOffset ? new HashMap() : null;
    }

    public List<Node> select(Node parent, long input, int count, String type) {
        return this.select(parent, input, count, type, (Predicate<Node>)Predicates.alwaysTrue());
    }

    public List<Node> select(Node parent, long input, int count, String type, Predicate<Node> nodePredicate) {
        Integer offset;
        int childCount = parent.getChildrenCount(type);
        if (childCount < count) {
            logger.error(count + " nodes of type " + type + " were requested but the tree has only " + childCount + " nodes!");
        }
        ArrayList<Node> selected = new ArrayList<Node>(count);
        if (this.keepOffset) {
            offset = this.roundOffset.get(input);
            if (offset == null) {
                offset = 0;
                this.roundOffset.put(input, offset);
            }
        } else {
            offset = 0;
        }
        int rPrime = 0;
        for (int r = 1; r <= count; ++r) {
            boolean retryOrigin;
            int failure = 0;
            int loopbackCount = 0;
            boolean escape = false;
            Node out = null;
            block1: do {
                boolean retryNode;
                retryOrigin = false;
                Node in = parent;
                HashSet<Node> rejected = new HashSet<Node>();
                do {
                    boolean predicateRejected;
                    retryNode = false;
                    rPrime = r + offset + failure;
                    logger.trace("{}.select({}, {})", new Object[]{in, input, rPrime});
                    Selector selector = new Selector(in);
                    out = selector.select(input, rPrime);
                    if (!out.getType().equalsIgnoreCase(type)) {
                        logger.trace("selected output {} for data {} didn't match the type {}: walking down the hierarchy...", new Object[]{out, input, type});
                        in = out;
                        retryNode = true;
                        continue;
                    }
                    boolean bl = predicateRejected = !nodePredicate.apply((Object)out);
                    if (selected.contains(out) || predicateRejected) {
                        if (predicateRejected) {
                            logger.trace("{} was rejected by the node predicate for data {}: rejecting and increasing rPrime", (Object)out, (Object)input);
                            rejected.add(out);
                        } else {
                            logger.trace("{} was already selected for data {}: rejecting and increasing rPrime", (Object)out, (Object)input);
                        }
                        if (this.allChildNodesEliminated(in, selected, rejected)) {
                            logger.trace("all child nodes of {} have been eliminated", (Object)in);
                            if (loopbackCount == 50) {
                                escape = true;
                                continue block1;
                            }
                            ++loopbackCount;
                            logger.trace("looping back to the original parent node ({})", (Object)parent);
                            retryOrigin = true;
                        } else {
                            retryNode = true;
                        }
                        ++failure;
                        continue;
                    }
                    if (!this.nodeIsOut(out)) continue block1;
                    logger.trace("{} is marked as out (failed or over the maximum assignment) for data {}! looping back to the original parent node", (Object)out, (Object)input);
                    ++failure;
                    if (loopbackCount == 50) {
                        escape = true;
                        continue block1;
                    }
                    ++loopbackCount;
                    retryOrigin = true;
                } while (retryNode);
            } while (retryOrigin);
            if (escape) {
                logger.debug("we could not select a node for data {} under parent {}; a smaller data set than is requested will be returned", (Object)input, (Object)parent);
                continue;
            }
            logger.trace("{} was selected for data {}", (Object)out, (Object)input);
            selected.add(out);
        }
        if (this.keepOffset) {
            this.roundOffset.put(input, rPrime);
        }
        return selected;
    }

    private boolean nodeIsOut(Node node) {
        if (node.getWeight() == 0L) {
            return true;
        }
        return node.isLeaf() && node.isFailed();
    }

    private boolean allChildNodesEliminated(Node parent, List<Node> selected, Set<Node> rejected) {
        List<Node> children = parent.getChildren();
        if (children != null) {
            for (Node child : children) {
                if (this.nodeIsOut(child) || selected.contains(child) || rejected.contains(child)) continue;
                return false;
            }
        }
        return true;
    }

    private class Selector {
        private final Map<Node, Long> straws = new HashMap<Node, Long>();
        private final JenkinsHash hashFunction;

        public Selector(Node node) {
            if (!node.isLeaf()) {
                List<Node> sortedNodes = this.sortNodes(node.getChildren());
                int numLeft = sortedNodes.size();
                float straw = 1.0f;
                float wbelow = 0.0f;
                float lastw = 0.0f;
                int i = 0;
                int length = sortedNodes.size();
                while (i < length) {
                    Node current = sortedNodes.get(i);
                    if (current.getWeight() == 0L) {
                        this.straws.put(current, 0L);
                        ++i;
                        continue;
                    }
                    this.straws.put(current, (long)(straw * 65536.0f));
                    if (++i == length) break;
                    current = sortedNodes.get(i);
                    Node previous = sortedNodes.get(i - 1);
                    if (current.getWeight() == previous.getWeight()) continue;
                    wbelow += ((float)previous.getWeight() - lastw) * (float)numLeft;
                    for (int j = i; j < length && sortedNodes.get(j).getWeight() == current.getWeight(); ++j) {
                        --numLeft;
                    }
                    float wnext = (long)numLeft * (current.getWeight() - previous.getWeight());
                    float pbelow = wbelow / (wbelow + wnext);
                    straw = (float)((double)straw * Math.pow(1.0 / (double)pbelow, 1.0 / (double)numLeft));
                    lastw = previous.getWeight();
                }
            }
            this.hashFunction = new JenkinsHash();
        }

        private List<Node> sortNodes(List<Node> nodes) {
            ArrayList<Node> ret = new ArrayList<Node>(nodes);
            this.sortNodesInPlace(ret);
            return ret;
        }

        private void sortNodesInPlace(List<Node> nodes) {
            Collections.sort(nodes, new Comparator<Node>(){

                @Override
                public int compare(Node n1, Node n2) {
                    if (n2.getWeight() == n1.getWeight()) {
                        return 0;
                    }
                    return n2.getWeight() - n1.getWeight() > 0L ? 1 : -1;
                }
            });
        }

        public Node select(long input, long round) {
            Node selected = null;
            long hiScore = -1L;
            for (Map.Entry<Node, Long> e : this.straws.entrySet()) {
                long straw;
                Node child = e.getKey();
                long score = this.weightedScore(child, straw = e.getValue().longValue(), input, round);
                if (score <= hiScore) continue;
                selected = child;
                hiScore = score;
            }
            if (selected == null) {
                throw new IllegalStateException();
            }
            return selected;
        }

        private long weightedScore(Node child, long straw, long input, long round) {
            long hash = this.hashFunction.hash(input, child.getId(), round);
            long weightedScore = (hash &= 0xFFFFL) * straw;
            return weightedScore;
        }
    }
}

