/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.parquet.filter2.dictionarylevel;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import org.apache.flink.table.store.shaded.org.apache.parquet.Preconditions;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.Dictionary;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.Encoding;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.EncodingStats;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DictionaryPage;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.flink.table.store.shaded.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.flink.table.store.shaded.org.apache.parquet.filter2.predicate.Operators;
import org.apache.flink.table.store.shaded.org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.PrimitiveComparator;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryFilter
implements FilterPredicate.Visitor<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(DictionaryFilter.class);
    private static final boolean BLOCK_MIGHT_MATCH = false;
    private static final boolean BLOCK_CANNOT_MATCH = true;
    private final Map<ColumnPath, ColumnChunkMetaData> columns = new HashMap<ColumnPath, ColumnChunkMetaData>();
    private final DictionaryPageReadStore dictionaries;

    public static boolean canDrop(FilterPredicate pred, List<ColumnChunkMetaData> columns, DictionaryPageReadStore dictionaries) {
        Preconditions.checkNotNull(pred, "pred");
        Preconditions.checkNotNull(columns, "columns");
        return pred.accept(new DictionaryFilter(columns, dictionaries));
    }

    private DictionaryFilter(List<ColumnChunkMetaData> columnsList, DictionaryPageReadStore dictionaries) {
        for (ColumnChunkMetaData chunk : columnsList) {
            this.columns.put(chunk.getPath(), chunk);
        }
        this.dictionaries = dictionaries;
    }

    private ColumnChunkMetaData getColumnChunk(ColumnPath columnPath) {
        return this.columns.get(columnPath);
    }

    private <T extends Comparable<T>> Set<T> expandDictionary(ColumnChunkMetaData meta) throws IOException {
        IntFunction<Object> dictValueProvider;
        ColumnDescriptor col = new ColumnDescriptor(meta.getPath().toArray(), meta.getPrimitiveType(), -1, -1);
        DictionaryPage page = this.dictionaries.readDictionaryPage(col);
        if (page == null) {
            return null;
        }
        Dictionary dict = page.getEncoding().initDictionary(col, page);
        PrimitiveType.PrimitiveTypeName type = meta.getPrimitiveType().getPrimitiveTypeName();
        switch (type) {
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                dictValueProvider = dict::decodeToBinary;
                break;
            }
            case INT32: {
                dictValueProvider = dict::decodeToInt;
                break;
            }
            case INT64: {
                dictValueProvider = dict::decodeToLong;
                break;
            }
            case FLOAT: {
                dictValueProvider = dict::decodeToFloat;
                break;
            }
            case DOUBLE: {
                dictValueProvider = dict::decodeToDouble;
                break;
            }
            default: {
                LOG.warn("Unsupported dictionary type: {}", (Object)type);
                return null;
            }
        }
        HashSet<Comparable> dictSet = new HashSet<Comparable>();
        for (int i = 0; i <= dict.getMaxId(); ++i) {
            dictSet.add((Comparable)dictValueProvider.apply(i));
        }
        return dictSet;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.Eq<T> eq) {
        Comparable value = eq.getValue();
        if (value == null) {
            return false;
        }
        Operators.Column filterColumn = eq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        if (DictionaryFilter.hasNonDictionaryPages(meta)) {
            return false;
        }
        try {
            Set<T> dictSet = this.expandDictionary(meta);
            if (dictSet != null && !dictSet.contains(value)) {
                return true;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to process dictionary for filter evaluation.", (Throwable)e);
        }
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.NotEq<T> notEq) {
        Operators.Column filterColumn = notEq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        Comparable value = notEq.getValue();
        if (value == null && meta == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (meta == null) {
            return false;
        }
        if (DictionaryFilter.hasNonDictionaryPages(meta)) {
            return false;
        }
        try {
            boolean mayContainNull;
            Set<T> dictSet = this.expandDictionary(meta);
            boolean bl = mayContainNull = meta.getStatistics() == null || !meta.getStatistics().isNumNullsSet() || meta.getStatistics().getNumNulls() > 0L;
            if (dictSet != null && dictSet.size() == 1 && dictSet.contains(value) && !mayContainNull) {
                return true;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to process dictionary for filter evaluation.", (Throwable)e);
        }
        return false;
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.Lt<T> lt) {
        Operators.Column filterColumn = lt.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        if (DictionaryFilter.hasNonDictionaryPages(meta)) {
            return false;
        }
        Comparable value = lt.getValue();
        try {
            Set<T> dictSet = this.expandDictionary(meta);
            if (dictSet == null) {
                return false;
            }
            PrimitiveComparator<Comparable> comparator = meta.getPrimitiveType().comparator();
            for (Comparable entry : dictSet) {
                if (comparator.compare(value, entry) <= 0) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to process dictionary for filter evaluation.", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.LtEq<T> ltEq) {
        Operators.Column filterColumn = ltEq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        if (DictionaryFilter.hasNonDictionaryPages(meta)) {
            return false;
        }
        Comparable value = ltEq.getValue();
        filterColumn.getColumnPath();
        try {
            Set<T> dictSet = this.expandDictionary(meta);
            if (dictSet == null) {
                return false;
            }
            PrimitiveComparator<Comparable> comparator = meta.getPrimitiveType().comparator();
            for (Comparable entry : dictSet) {
                if (comparator.compare(value, entry) < 0) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to process dictionary for filter evaluation.", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.Gt<T> gt) {
        Operators.Column filterColumn = gt.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        if (DictionaryFilter.hasNonDictionaryPages(meta)) {
            return false;
        }
        Comparable value = gt.getValue();
        try {
            Set<T> dictSet = this.expandDictionary(meta);
            if (dictSet == null) {
                return false;
            }
            PrimitiveComparator<Comparable> comparator = meta.getPrimitiveType().comparator();
            for (Comparable entry : dictSet) {
                if (comparator.compare(value, entry) >= 0) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to process dictionary for filter evaluation.", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T extends Comparable<T>> Boolean visit(Operators.GtEq<T> gtEq) {
        Operators.Column filterColumn = gtEq.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        if (meta == null) {
            return true;
        }
        if (DictionaryFilter.hasNonDictionaryPages(meta)) {
            return false;
        }
        Comparable value = gtEq.getValue();
        filterColumn.getColumnPath();
        try {
            Set<T> dictSet = this.expandDictionary(meta);
            if (dictSet == null) {
                return false;
            }
            PrimitiveComparator<Comparable> comparator = meta.getPrimitiveType().comparator();
            for (Comparable entry : dictSet) {
                if (comparator.compare(value, entry) > 0) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to process dictionary for filter evaluation.", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean visit(Operators.And and) {
        return and.getLeft().accept(this) != false || and.getRight().accept(this) != false;
    }

    @Override
    public Boolean visit(Operators.Or or) {
        return or.getLeft().accept(this) != false && or.getRight().accept(this) != false;
    }

    @Override
    public Boolean visit(Operators.Not not) {
        throw new IllegalArgumentException("This predicate contains a not! Did you forget to run this predicate through LogicalInverseRewriter? " + not);
    }

    private <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> ud, boolean inverted) {
        Operators.Column<T> filterColumn = ud.getColumn();
        ColumnChunkMetaData meta = this.getColumnChunk(filterColumn.getColumnPath());
        U udp = ud.getUserDefinedPredicate();
        if (meta == null) {
            if (inverted) {
                return ((UserDefinedPredicate)udp).acceptsNullValue();
            }
            return !((UserDefinedPredicate)udp).acceptsNullValue();
        }
        if (DictionaryFilter.hasNonDictionaryPages(meta)) {
            return false;
        }
        try {
            Set<T> dictSet = this.expandDictionary(meta);
            if (dictSet == null) {
                return false;
            }
            for (Comparable entry : dictSet) {
                boolean keep = ((UserDefinedPredicate)udp).keep((Comparable)entry);
                if ((!keep || inverted) && (keep || !inverted)) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to process dictionary for filter evaluation.", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.UserDefined<T, U> udp) {
        return this.visit(udp, false);
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Boolean visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return this.visit(udp.getUserDefined(), true);
    }

    private static boolean hasNonDictionaryPages(ColumnChunkMetaData meta) {
        EncodingStats stats = meta.getEncodingStats();
        if (stats != null) {
            return stats.hasNonDictionaryEncodedPages();
        }
        HashSet<Encoding> encodings = new HashSet<Encoding>(meta.getEncodings());
        if (encodings.remove((Object)Encoding.PLAIN_DICTIONARY)) {
            encodings.remove((Object)Encoding.RLE);
            encodings.remove((Object)Encoding.BIT_PACKED);
            return !encodings.isEmpty();
        }
        return true;
    }
}

