/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive.objectinspector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.hive.HiveTypeUtils;
import org.apache.flink.table.store.hive.objectinspector.TableStoreObjectInspectorFactory;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class TableStoreRowDataObjectInspector
extends StructObjectInspector {
    private final List<TableStoreStructField> structFields = new ArrayList<TableStoreStructField>();
    private final Map<String, TableStoreStructField> structFieldMap = new HashMap<String, TableStoreStructField>();
    private final String typeName;

    public TableStoreRowDataObjectInspector(List<String> fieldNames, List<LogicalType> fieldTypes, List<String> fieldComments) {
        StringBuilder typeNameBuilder = new StringBuilder("struct<");
        for (int i = 0; i < fieldNames.size(); ++i) {
            String name = fieldNames.get(i);
            LogicalType logicalType = fieldTypes.get(i);
            TableStoreStructField structField = new TableStoreStructField(name, TableStoreObjectInspectorFactory.create(logicalType), i, RowDataUtils.createNullCheckingFieldGetter(logicalType, i), fieldComments.get(i));
            this.structFields.add(structField);
            this.structFieldMap.put(name, structField);
            if (i > 0) {
                typeNameBuilder.append(",");
            }
            typeNameBuilder.append(name).append(":").append(HiveTypeUtils.logicalTypeToTypeInfo(logicalType).getTypeName());
        }
        typeNameBuilder.append(">");
        this.typeName = typeNameBuilder.toString();
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.structFields;
    }

    public StructField getStructFieldRef(String name) {
        return this.structFieldMap.get(name);
    }

    public Object getStructFieldData(Object o, StructField structField) {
        RowData rowData = (RowData)o;
        return ((TableStoreStructField)structField).fieldGetter.getFieldOrNull(rowData);
    }

    public List<Object> getStructFieldsDataAsList(Object o) {
        RowData rowData = (RowData)o;
        return this.structFields.stream().map(f -> ((TableStoreStructField)f).fieldGetter.getFieldOrNull(rowData)).collect(Collectors.toList());
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    private static class TableStoreStructField
    implements StructField {
        private final String name;
        private final ObjectInspector objectInspector;
        private final int idx;
        private final RowData.FieldGetter fieldGetter;
        private final String comment;

        private TableStoreStructField(String name, ObjectInspector objectInspector, int idx, RowData.FieldGetter fieldGetter, String comment) {
            this.name = name;
            this.objectInspector = objectInspector;
            this.idx = idx;
            this.fieldGetter = fieldGetter;
            this.comment = comment;
        }

        public String getFieldName() {
            return this.name;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.objectInspector;
        }

        public int getFieldID() {
            return this.idx;
        }

        public String getFieldComment() {
            return this.comment;
        }
    }
}

