/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.async;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationResult;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.async.OperationKey;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.async.TriggerResponse;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.concurrent.FutureUtils;

public abstract class AbstractAsynchronousOperationHandlers<K extends OperationKey, R> {
    private final CompletedOperationCache<K, R> completedOperationCache;

    protected AbstractAsynchronousOperationHandlers(Duration cacheDuration) {
        this.completedOperationCache = new CompletedOperationCache(cacheDuration);
    }

    protected abstract class StatusHandler<T extends RestfulGateway, V, M extends MessageParameters>
    extends AbstractRestHandler<T, EmptyRequestBody, AsynchronousOperationResult<V>, M> {
        protected StatusHandler(GatewayRetriever<? extends T> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, AsynchronousOperationResult<V>, M> messageHeaders) {
            super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        }

        @Override
        public CompletableFuture<AsynchronousOperationResult<V>> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull T gateway) throws RestHandlerException {
            Object key = this.getOperationKey(request);
            Optional operationResultOptional = AbstractAsynchronousOperationHandlers.this.completedOperationCache.get(key);
            if (!operationResultOptional.isPresent()) {
                return FutureUtils.completedExceptionally(new NotFoundException("Operation not found under key: " + key));
            }
            OperationResult operationResult = operationResultOptional.get();
            switch (operationResult.getStatus()) {
                case SUCCESS: {
                    return CompletableFuture.completedFuture(AsynchronousOperationResult.completed(this.operationResultResponse(operationResult.getResult())));
                }
                case FAILURE: {
                    return CompletableFuture.completedFuture(AsynchronousOperationResult.completed(this.exceptionalOperationResultResponse(operationResult.getThrowable())));
                }
                case IN_PROGRESS: {
                    return CompletableFuture.completedFuture(AsynchronousOperationResult.inProgress());
                }
            }
            throw new IllegalStateException("No handler for operation status " + (Object)((Object)operationResult.getStatus()) + ", encountered for key " + key);
        }

        @Override
        public CompletableFuture<Void> closeHandlerAsync() {
            return AbstractAsynchronousOperationHandlers.this.completedOperationCache.closeAsync();
        }

        protected abstract K getOperationKey(HandlerRequest<EmptyRequestBody> var1);

        protected abstract V exceptionalOperationResultResponse(Throwable var1);

        protected abstract V operationResultResponse(R var1);
    }

    protected abstract class TriggerHandler<T extends RestfulGateway, B extends RequestBody, M extends MessageParameters>
    extends AbstractRestHandler<T, B, TriggerResponse, M> {
        protected TriggerHandler(GatewayRetriever<? extends T> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<B, TriggerResponse, M> messageHeaders) {
            super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        }

        @Override
        public CompletableFuture<TriggerResponse> handleRequest(@Nonnull HandlerRequest<B> request, @Nonnull T gateway) throws RestHandlerException {
            CompletableFuture resultFuture = this.triggerOperation(request, gateway);
            Object operationKey = this.createOperationKey(request);
            AbstractAsynchronousOperationHandlers.this.completedOperationCache.registerOngoingOperation(operationKey, resultFuture);
            return CompletableFuture.completedFuture(new TriggerResponse(((OperationKey)operationKey).getTriggerId()));
        }

        protected abstract CompletableFuture<R> triggerOperation(HandlerRequest<B> var1, T var2) throws RestHandlerException;

        protected abstract K createOperationKey(HandlerRequest<B> var1);
    }
}

