/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.io.Serializable;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.table.AbstractFileSystemTable;
import org.apache.flink.connector.file.table.DeserializationSchemaAdapter;
import org.apache.flink.connector.file.table.FileInfoExtractorBulkFormat;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.LimitableBulkFormat;
import org.apache.flink.connector.file.table.ProjectingBulkFormat;
import org.apache.flink.connector.file.table.format.BulkDecodingFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsPartitionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.CollectionUtil;

@Internal
public class FileSystemTableSource
extends AbstractFileSystemTable
implements ScanTableSource,
SupportsProjectionPushDown,
SupportsLimitPushDown,
SupportsPartitionPushDown,
SupportsFilterPushDown,
SupportsReadingMetadata {
    @Nullable
    private final DecodingFormat<BulkFormat<RowData, FileSourceSplit>> bulkReaderFormat;
    @Nullable
    private final DecodingFormat<DeserializationSchema<RowData>> deserializationFormat;
    private List<Map<String, String>> remainingPartitions;
    private List<ResolvedExpression> filters;
    private Long limit;
    private int[][] projectFields;
    private List<String> metadataKeys;
    private DataType producedDataType;

    public FileSystemTableSource(ObjectIdentifier tableIdentifier, DataType physicalRowDataType, List<String> partitionKeys, ReadableConfig tableOptions, @Nullable DecodingFormat<BulkFormat<RowData, FileSourceSplit>> bulkReaderFormat, @Nullable DecodingFormat<DeserializationSchema<RowData>> deserializationFormat) {
        super(tableIdentifier, physicalRowDataType, partitionKeys, tableOptions);
        if (Stream.of(bulkReaderFormat, deserializationFormat).allMatch(Objects::isNull)) {
            String identifier = tableOptions.get(FactoryUtil.FORMAT);
            throw new ValidationException(String.format("Could not find any format factory for identifier '%s' in the classpath.", identifier));
        }
        this.bulkReaderFormat = bulkReaderFormat;
        this.deserializationFormat = deserializationFormat;
        this.producedDataType = physicalRowDataType;
    }

    @Override
    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        if (!this.partitionKeys.isEmpty() && this.getOrFetchPartitions().isEmpty()) {
            return InputFormatProvider.of(new CollectionInputFormat(new ArrayList(), null));
        }
        List<Object> metadataKeys = this.metadataKeys == null ? Collections.emptyList() : this.metadataKeys;
        List<ReadableFileInfo> metadataToExtract = metadataKeys.stream().map(ReadableFileInfo::resolve).collect(Collectors.toList());
        List<String> partitionKeysToExtract = DataType.getFieldNames(this.producedDataType).stream().filter(this.partitionKeys::contains).collect(Collectors.toList());
        DataType physicalDataType = this.physicalRowDataType;
        Projection partitionKeysProjections = Projection.fromFieldNames(physicalDataType, partitionKeysToExtract);
        Projection physicalProjections = (this.projectFields != null ? Projection.of(this.projectFields) : Projection.all(physicalDataType)).difference(partitionKeysProjections);
        physicalDataType = partitionKeysProjections.complement(physicalDataType).project(physicalDataType);
        if (this.bulkReaderFormat != null) {
            if (this.bulkReaderFormat instanceof BulkDecodingFormat && this.filters != null && this.filters.size() > 0) {
                ((BulkDecodingFormat)this.bulkReaderFormat).applyFilters(this.filters);
            }
            BulkFormat<RowData, FileSourceSplit> format = this.bulkReaderFormat instanceof ProjectableDecodingFormat ? (BulkFormat<RowData, FileSourceSplit>)((ProjectableDecodingFormat)this.bulkReaderFormat).createRuntimeDecoder(scanContext, physicalDataType, physicalProjections.toNestedIndexes()) : new ProjectingBulkFormat(this.bulkReaderFormat.createRuntimeDecoder(scanContext, physicalDataType), physicalProjections.toTopLevelIndexes(), scanContext.createTypeInformation(physicalProjections.project(physicalDataType)));
            format = this.wrapBulkFormat(scanContext, format, this.producedDataType, metadataToExtract, partitionKeysToExtract);
            return this.createSourceProvider(format);
        }
        if (this.deserializationFormat != null) {
            BulkFormat<RowData, FileSourceSplit> format = this.deserializationFormat instanceof ProjectableDecodingFormat ? new DeserializationSchemaAdapter((DeserializationSchema)((ProjectableDecodingFormat)this.deserializationFormat).createRuntimeDecoder(scanContext, physicalDataType, physicalProjections.toNestedIndexes())) : new ProjectingBulkFormat(new DeserializationSchemaAdapter(this.deserializationFormat.createRuntimeDecoder(scanContext, physicalDataType)), physicalProjections.toTopLevelIndexes(), scanContext.createTypeInformation(physicalProjections.project(physicalDataType)));
            format = this.wrapBulkFormat(scanContext, format, this.producedDataType, metadataToExtract, partitionKeysToExtract);
            return this.createSourceProvider(format);
        }
        throw new TableException("Can not find format factory.");
    }

    private BulkFormat<RowData, FileSourceSplit> wrapBulkFormat(ScanTableSource.ScanContext context, BulkFormat<RowData, FileSourceSplit> bulkFormat, DataType producedDataType, List<ReadableFileInfo> metadata, List<String> partitionKeys) {
        if (!metadata.isEmpty() || !partitionKeys.isEmpty()) {
            List<String> producedFieldNames = DataType.getFieldNames(producedDataType);
            Map<String, FileInfoAccessor> metadataColumns = IntStream.range(0, metadata.size()).mapToObj(i -> {
                int columnPos = producedFieldNames.size() - metadata.size() + i;
                return CollectionUtil.entry(producedFieldNames.get(columnPos), ((ReadableFileInfo)metadata.get(i)).getAccessor());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            bulkFormat = new FileInfoExtractorBulkFormat(bulkFormat, producedDataType, context.createTypeInformation(producedDataType), metadataColumns, partitionKeys, this.defaultPartName);
        }
        bulkFormat = LimitableBulkFormat.create(bulkFormat, this.limit);
        return bulkFormat;
    }

    private SourceProvider createSourceProvider(BulkFormat<RowData, FileSourceSplit> bulkFormat) {
        FileSource.FileSourceBuilder<RowData> fileSourceBuilder = FileSource.forBulkFileFormat(bulkFormat, this.paths());
        this.tableOptions.getOptional(FileSystemConnectorOptions.SOURCE_MONITOR_INTERVAL).ifPresent(x$0 -> fileSourceBuilder.monitorContinuously((Duration)x$0));
        return SourceProvider.of(fileSourceBuilder.build());
    }

    private Path[] paths() {
        if (this.partitionKeys.isEmpty()) {
            return new Path[]{this.path};
        }
        return (Path[])this.getOrFetchPartitions().stream().map(this::toFullLinkedPartSpec).map(PartitionPathUtils::generatePartitionPath).map(n -> new Path(this.path, (String)n)).toArray(Path[]::new);
    }

    @Override
    public ChangelogMode getChangelogMode() {
        if (this.bulkReaderFormat != null) {
            return this.bulkReaderFormat.getChangelogMode();
        }
        if (this.deserializationFormat != null) {
            return this.deserializationFormat.getChangelogMode();
        }
        throw new TableException("Can not find format factory.");
    }

    @Override
    public SupportsFilterPushDown.Result applyFilters(List<ResolvedExpression> filters) {
        this.filters = new ArrayList<ResolvedExpression>(filters);
        return SupportsFilterPushDown.Result.of(new ArrayList<ResolvedExpression>(filters), new ArrayList<ResolvedExpression>(filters));
    }

    @Override
    public void applyLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public Optional<List<Map<String, String>>> listPartitions() {
        try {
            return Optional.of(PartitionPathUtils.searchPartSpecAndPaths(this.path.getFileSystem(), this.path, this.partitionKeys.size()).stream().map(tuple2 -> (LinkedHashMap)tuple2.f0).map(spec -> {
                LinkedHashMap ret = new LinkedHashMap();
                spec.forEach((k, v) -> ret.put(k, this.defaultPartName.equals(v) ? null : v));
                return ret;
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new TableException("Fetch partitions fail.", e);
        }
    }

    @Override
    public void applyPartitions(List<Map<String, String>> remainingPartitions) {
        this.remainingPartitions = remainingPartitions;
    }

    @Override
    public boolean supportsNestedProjection() {
        return false;
    }

    @Override
    public FileSystemTableSource copy() {
        FileSystemTableSource source = new FileSystemTableSource(this.tableIdentifier, this.physicalRowDataType, this.partitionKeys, this.tableOptions, this.bulkReaderFormat, this.deserializationFormat);
        source.partitionKeys = this.partitionKeys;
        source.remainingPartitions = this.remainingPartitions;
        source.filters = this.filters;
        source.limit = this.limit;
        source.projectFields = this.projectFields;
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    @Override
    public String asSummaryString() {
        return "Filesystem";
    }

    private List<Map<String, String>> getOrFetchPartitions() {
        if (this.remainingPartitions == null) {
            this.remainingPartitions = this.listPartitions().get();
        }
        return this.remainingPartitions;
    }

    private LinkedHashMap<String, String> toFullLinkedPartSpec(Map<String, String> part) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String k : this.partitionKeys) {
            if (!part.containsKey(k)) {
                throw new TableException("Partition keys are: " + this.partitionKeys + ", incomplete partition spec: " + part);
            }
            map.put(k, part.get(k));
        }
        return map;
    }

    @Override
    public void applyProjection(int[][] projectedFields, DataType producedDataType) {
        this.projectFields = projectedFields;
        this.producedDataType = producedDataType;
    }

    @Override
    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }

    @Override
    public Map<String, DataType> listReadableMetadata() {
        return Arrays.stream(ReadableFileInfo.values()).collect(Collectors.toMap(ReadableFileInfo::getKey, ReadableFileInfo::getDataType));
    }

    static enum ReadableFileInfo implements Serializable
    {
        FILEPATH("file.path", (DataType)DataTypes.STRING().notNull(), new FileInfoAccessor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValue(FileSourceSplit split) {
                return StringData.fromString(split.path().getPath());
            }
        }),
        FILENAME("file.name", (DataType)DataTypes.STRING().notNull(), new FileInfoAccessor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValue(FileSourceSplit split) {
                return StringData.fromString(Paths.get(split.path().getPath(), new String[0]).getFileName().toString());
            }
        }),
        SIZE("file.size", (DataType)DataTypes.BIGINT().notNull(), new FileInfoAccessor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValue(FileSourceSplit split) {
                return split.fileSize();
            }
        }),
        MODIFICATION_TIME("file.modification-time", (DataType)DataTypes.TIMESTAMP_LTZ(3).notNull(), new FileInfoAccessor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getValue(FileSourceSplit split) {
                return TimestampData.fromEpochMillis(split.fileModificationTime());
            }
        });

        final String key;
        final DataType dataType;
        final FileInfoAccessor converter;

        private ReadableFileInfo(String key, DataType dataType, FileInfoAccessor converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }

        public String getKey() {
            return this.key;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public FileInfoAccessor getAccessor() {
            return this.converter;
        }

        public static ReadableFileInfo resolve(String key) {
            return Arrays.stream(ReadableFileInfo.values()).filter(readableFileInfo -> readableFileInfo.getKey().equals(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot resolve the provided ReadableMetadata key"));
        }
    }

    static interface FileInfoAccessor
    extends Serializable {
        public Object getValue(FileSourceSplit var1);
    }
}

