/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.tasks.configuration;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.OperatingSystem;
import org.flexunit.ant.tasks.configuration.StepConfiguration;

public class TestRunConfiguration
implements StepConfiguration {
    private final int FLOOR_FOR_PORT = 1;
    private final int SHORTEST_SOCKET_TIMEOUT = 5000;
    private String player;
    private File command = null;
    private int display = 99;
    private boolean failOnTestFailure = false;
    private String failureProperty = "flexunit.failed";
    private File flexHome = null;
    private boolean headless = false;
    private boolean isLocalTrusted = true;
    private int port = 1024;
    private File reportDir = null;
    private int serverBufferSize = 262144;
    private int socketTimeout = 60000;
    private File swf = null;
    private String url = null;
    private File precompiledAppDescriptor = null;
    private OperatingSystem os = OperatingSystem.identify();

    public File getCommand() {
        return this.command;
    }

    public void setCommand(File file) {
        this.command = file;
    }

    public boolean isCustomCommand() {
        return this.command != null;
    }

    public int getDisplay() {
        return this.display;
    }

    public void setDisplay(int n) {
        this.display = n;
    }

    public boolean isFailOnTestFailure() {
        return this.failOnTestFailure;
    }

    public void setFailOnTestFailure(boolean bl) {
        this.failOnTestFailure = bl;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFailureProperty(String string) {
        this.failureProperty = string;
    }

    public File getFlexHome() {
        return this.flexHome;
    }

    public void setFlexHome(File file) {
        this.flexHome = file;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean bl) {
        this.headless = bl;
    }

    public boolean isLocalTrusted() {
        return this.isLocalTrusted;
    }

    public boolean usePolicyFile() {
        return !this.isLocalTrusted && this.player.equals("flash");
    }

    public void setLocalTrusted(boolean bl) {
        this.isLocalTrusted = bl;
    }

    public String getPlayer() {
        return this.player;
    }

    public void setPlayer(String string) {
        this.player = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File file) {
        this.reportDir = file;
    }

    public int getServerBufferSize() {
        return this.serverBufferSize;
    }

    public void setServerBufferSize(int n) {
        this.serverBufferSize = n;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public File getSwf() {
        return this.swf;
    }

    public void setSwf(File file) {
        this.swf = file;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public File getPrecompiledAppDescriptor() {
        return this.precompiledAppDescriptor;
    }

    public void setPrecompiledAppDescriptor(File file) {
        this.precompiledAppDescriptor = file;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    public void validate() throws BuildException {
        if (this.port < 1) {
            throw new BuildException("The provided 'port' property value [" + this.port + "] must be great than " + 1 + ".");
        }
        if (this.socketTimeout < 5000) {
            throw new BuildException("The provided 'timeout' property value [" + this.socketTimeout + "] must be great than " + 5000 + ".");
        }
        if (this.reportDir != null && !this.reportDir.exists()) {
            LoggingUtil.log("Provided report directory path [" + this.reportDir.getPath() + "] does not exist.");
        }
        if (this.command != null && !this.command.exists()) {
            throw new BuildException("The provided command path [" + this.command + "] does not exist.");
        }
        if (this.headless) {
            if (OperatingSystem.identify() != OperatingSystem.LINUX) {
                throw new BuildException("Headless mode can only be used on Linux with vncserver installed.");
            }
            if (this.display < 1) {
                throw new BuildException("The provided 'display' number must be set higher than 0.  99 or higher is recommended.");
            }
        }
    }

    public void log() {
        LoggingUtil.log("Using the following settings for the test run:");
        if (this.flexHome != null) {
            LoggingUtil.log("\tFLEX_HOME: [" + this.flexHome.getAbsolutePath() + "]");
        }
        LoggingUtil.log("\thaltonfailure: [" + this.failOnTestFailure + "]");
        LoggingUtil.log("\theadless: [" + this.headless + "]");
        LoggingUtil.log("\tdisplay: [" + this.display + "]");
        LoggingUtil.log("\tlocalTrusted: [" + this.isLocalTrusted + "]");
        LoggingUtil.log("\tplayer: [" + this.player + "]");
        if (this.isCustomCommand()) {
            LoggingUtil.log("\tcommand: [" + this.command + "]");
        }
        LoggingUtil.log("\tport: [" + this.port + "]");
        LoggingUtil.log("\tswf: [" + this.swf + "]");
        LoggingUtil.log("\ttimeout: [" + this.socketTimeout + "ms]");
        LoggingUtil.log("\ttoDir: [" + this.reportDir.getAbsolutePath() + "]");
    }
}

