////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

/**
 *  The color of text when the component is enabled and has focus.
 *  
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="focusedTextSelectionColor", type="uint", format="Color", inherit="yes")]

/**
 *  The color of text when the component is disabled.
 *  
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 * 
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="inactiveTextSelectionColor", type="uint", format="Color", inherit="yes")]

/**
 *  The color of text when the component is enabled but does not have focus.
 *  
 *  <p><b>For the Mobile theme, this is not supported.</b></p>
 *  
 *  @langversion 3.0
 *  @playerversion Flash 10
 *  @playerversion AIR 1.5
 *  @productversion Flex 4
 */
[Style(name="unfocusedTextSelectionColor", type="uint", format="Color", inherit="yes")]
