/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;

public class SingleNodeIterator
implements AxisIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private final NodeInfo item;
    private int position = 0;

    private SingleNodeIterator(NodeInfo value) {
        this.item = value;
    }

    public static AxisIterator makeIterator(NodeInfo item) {
        if (item == null) {
            return EmptyIterator.ofNodes();
        }
        return new SingleNodeIterator(item);
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.position == 0;
    }

    @Override
    public NodeInfo next() {
        if (this.position == 0) {
            this.position = 1;
            return this.item;
        }
        if (this.position == 1) {
            this.position = -1;
            return null;
        }
        return null;
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public SequenceIterator getReverseIterator() {
        return new SingleNodeIterator(this.item);
    }

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }

    public NodeInfo getValue() {
        return this.item;
    }

    @Override
    public GroundedValue materialize() {
        return SequenceTool.itemOrEmpty(this.item);
    }

    @Override
    public GroundedValue getResidue() {
        return SequenceTool.itemOrEmpty(this.item);
    }
}

