/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.text.NumberFormat;
import java.util.Calendar;
import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.SystemProperties;

public class CharUtilsPerfRun {
    private static final int WARM_UP = 100;
    private static final int COUNT = 5000;
    private static final char[] ALL_CHARS = new char[65535];

    public static void main(String[] args) {
        new CharUtilsPerfRun().run();
    }

    private void printlnTotal(String prefix, long startMillis) {
        long totalMillis = System.currentTimeMillis() - startMillis;
        System.out.println(prefix + ": " + NumberFormat.getInstance().format(totalMillis) + " milliseconds.");
    }

    private void printSysInfo() {
        System.out.println("Now: " + Calendar.getInstance().getTime());
        System.out.println(SystemProperties.getJavaVendor() + " " + SystemProperties.getJavaRuntimeName() + " " + SystemProperties.getJavaRuntimeVersion());
        System.out.println(SystemProperties.getJavaVmVendor() + " " + SystemProperties.getJavaVmName() + " " + SystemProperties.getJavaVmVersion());
        System.out.println(SystemProperties.getOsName() + " " + SystemProperties.getOsVersion() + " " + SystemProperties.getOsArch() + " " + System.getProperty("sun.cpu.isalist"));
    }

    private void run() {
        this.printSysInfo();
        long startMillis = System.currentTimeMillis();
        this.printlnTotal("Do nothing", startMillis);
        this.run_CharUtils_isAsciiNumeric(100);
        startMillis = System.currentTimeMillis();
        this.run_CharUtils_isAsciiNumeric(5000);
        this.printlnTotal("run_CharUtils_isAsciiNumeric", startMillis);
        this.run_inlined_CharUtils_isAsciiNumeric(100);
        startMillis = System.currentTimeMillis();
        this.run_inlined_CharUtils_isAsciiNumeric(5000);
        this.printlnTotal("run_inlined_CharUtils_isAsciiNumeric", startMillis);
        this.run_CharSet(100);
        startMillis = System.currentTimeMillis();
        this.run_CharSet(5000);
        this.printlnTotal("run_CharSet", startMillis);
    }

    private int run_CharSet(int loopCount) {
        int t = 0;
        for (int i = 0; i < loopCount; ++i) {
            for (char ch : ALL_CHARS) {
                boolean b = CharSet.ASCII_NUMERIC.contains(ch);
                t += b ? 1 : 0;
            }
        }
        return t;
    }

    private int run_CharUtils_isAsciiNumeric(int loopCount) {
        int t = 0;
        for (int i = 0; i < loopCount; ++i) {
            for (char ch : ALL_CHARS) {
                boolean b = CharUtils.isAsciiNumeric((char)ch);
                t += b ? 1 : 0;
            }
        }
        return t;
    }

    private int run_inlined_CharUtils_isAsciiNumeric(int loopCount) {
        int t = 0;
        for (int i = 0; i < loopCount; ++i) {
            for (char ch : ALL_CHARS) {
                boolean b = ch >= '0' && ch <= '9';
                t += b ? 1 : 0;
            }
        }
        return t;
    }

    static {
        for (int i = 0; i < 65535; i = (int)((char)(i + 1))) {
            CharUtilsPerfRun.ALL_CHARS[i] = i;
        }
    }
}

