/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.oned;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.AbstractHyperplane;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.spherical.oned.CutAngles;
import org.apache.commons.geometry.spherical.oned.Point1S;
import org.apache.commons.numbers.core.Precision;

public final class CutAngle
extends AbstractHyperplane<Point1S> {
    private final Point1S point;
    private final boolean positiveFacing;

    CutAngle(Point1S point, boolean positiveFacing, Precision.DoubleEquivalence precision) {
        super(precision);
        this.point = point;
        this.positiveFacing = positiveFacing;
    }

    public Point1S getPoint() {
        return this.point;
    }

    public double getAzimuth() {
        return this.point.getAzimuth();
    }

    public double getNormalizedAzimuth() {
        return this.point.getNormalizedAzimuth();
    }

    public boolean isPositiveFacing() {
        return this.positiveFacing;
    }

    public boolean eq(CutAngle other, Precision.DoubleEquivalence precision) {
        return this.point.eq(other.point, precision) && this.positiveFacing == other.positiveFacing;
    }

    public double offset(Point1S pt) {
        double dist = pt.getNormalizedAzimuth() - this.point.getNormalizedAzimuth();
        return this.positiveFacing ? dist : -dist;
    }

    public HyperplaneLocation classify(Point1S pt) {
        Precision.DoubleEquivalence precision;
        Point1S compPt = Point1S.ZERO.eq(pt, precision = this.getPrecision()) ? Point1S.ZERO : pt;
        double offsetValue = this.offset(compPt);
        double cmp = precision.signum(offsetValue);
        if (cmp > 0.0) {
            return HyperplaneLocation.PLUS;
        }
        if (cmp < 0.0) {
            return HyperplaneLocation.MINUS;
        }
        return HyperplaneLocation.ON;
    }

    public Point1S project(Point1S pt) {
        return this.point;
    }

    public CutAngle reverse() {
        return new CutAngle(this.point, !this.positiveFacing, this.getPrecision());
    }

    public CutAngle transform(Transform<Point1S> transform) {
        Point1S tPoint = (Point1S)transform.apply((Object)this.point);
        boolean tPositiveFacing = transform.preservesOrientation() == this.positiveFacing;
        return CutAngles.fromPointAndDirection(tPoint, tPositiveFacing, this.getPrecision());
    }

    public boolean similarOrientation(Hyperplane<Point1S> other) {
        return this.positiveFacing == ((CutAngle)other).positiveFacing;
    }

    public HyperplaneConvexSubset<Point1S> span() {
        return new CutAngleConvexSubset(this);
    }

    public int hashCode() {
        return Objects.hash(this.point, this.positiveFacing, this.getPrecision());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CutAngle)) {
            return false;
        }
        CutAngle other = (CutAngle)((Object)obj);
        return Objects.equals(this.getPrecision(), other.getPrecision()) && Objects.equals(this.point, other.point) && this.positiveFacing == other.positiveFacing;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName()).append("[point= ").append(this.point).append(", positiveFacing= ").append(this.isPositiveFacing()).append(']');
        return sb.toString();
    }

    private static final class CutAngleConvexSubset
    implements HyperplaneConvexSubset<Point1S> {
        private final CutAngle hyperplane;

        CutAngleConvexSubset(CutAngle hyperplane) {
            this.hyperplane = hyperplane;
        }

        public CutAngle getHyperplane() {
            return this.hyperplane;
        }

        public boolean isFull() {
            return false;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isInfinite() {
            return false;
        }

        public boolean isFinite() {
            return true;
        }

        public double getSize() {
            return 0.0;
        }

        public Point1S getCentroid() {
            return this.hyperplane.getPoint();
        }

        public RegionLocation classify(Point1S point) {
            if (this.hyperplane.contains(point)) {
                return RegionLocation.BOUNDARY;
            }
            return RegionLocation.OUTSIDE;
        }

        public Point1S closest(Point1S point) {
            return this.hyperplane.project(point);
        }

        public Split<CutAngleConvexSubset> split(Hyperplane<Point1S> splitter) {
            HyperplaneLocation side = splitter.classify((Point)this.hyperplane.getPoint());
            CutAngleConvexSubset minus = null;
            CutAngleConvexSubset plus = null;
            if (side == HyperplaneLocation.MINUS) {
                minus = this;
            } else if (side == HyperplaneLocation.PLUS) {
                plus = this;
            }
            return new Split((Object)minus, (Object)plus);
        }

        public List<CutAngleConvexSubset> toConvex() {
            return Collections.singletonList(this);
        }

        public CutAngleConvexSubset transform(Transform<Point1S> transform) {
            return new CutAngleConvexSubset(this.getHyperplane().transform(transform));
        }

        public CutAngleConvexSubset reverse() {
            return new CutAngleConvexSubset(this.hyperplane.reverse());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append("[hyperplane= ").append((Object)this.hyperplane).append(']');
            return sb.toString();
        }
    }
}

