//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//

package com.cloud.agent.api;

import com.cloud.agent.api.to.HostTO;
import com.cloud.host.Host;

public class CheckOnHostCommand extends Command {
    HostTO host;
    boolean reportCheckFailureIfOneStorageIsDown;

    protected CheckOnHostCommand() {
    }

    public CheckOnHostCommand(Host host) {
        this.host = new HostTO(host);
        setWait(20);
    }

    public CheckOnHostCommand(Host host, boolean reportCheckFailureIfOneStorageIsDown) {
        super();
        this.host = new HostTO(host);
        this.reportCheckFailureIfOneStorageIsDown = reportCheckFailureIfOneStorageIsDown;
    }

    public HostTO getHost() {
        return host;
    }

    public boolean isCheckFailedOnOneStorage() {
        return reportCheckFailureIfOneStorageIsDown;
    }

    @Override
    public boolean executeInSequence() {
        return false;
    }
}
