/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli;

import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.ExponentialBackoffRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;

public final class RaftUtils {
    private RaftUtils() {
    }

    public static RaftPeerId getPeerId(InetSocketAddress address) {
        return RaftUtils.getPeerId(address.getHostString(), address.getPort());
    }

    public static RaftPeerId getPeerId(String host, int port) {
        return RaftPeerId.getRaftPeerId((String)(host + "_" + port));
    }

    public static RaftClient createClient(RaftGroup raftGroup) {
        RaftProperties properties = new RaftProperties();
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)15L, (TimeUnit)TimeUnit.SECONDS));
        Properties sys = System.getProperties();
        sys.stringPropertyNames().forEach(key -> properties.set(key, sys.getProperty((String)key)));
        ExponentialBackoffRetry retryPolicy = ExponentialBackoffRetry.newBuilder().setBaseSleepTime(TimeDuration.valueOf((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS)).setMaxAttempts(10).setMaxSleepTime(TimeDuration.valueOf((long)100000L, (TimeUnit)TimeUnit.MILLISECONDS)).build();
        return RaftClient.newBuilder().setRaftGroup(raftGroup).setProperties(properties).setRetryPolicy((RetryPolicy)retryPolicy).build();
    }
}

