/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.server;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchRequest;
import org.apache.celeborn.common.network.protocol.Encodable;
import org.apache.celeborn.common.network.protocol.OneWayMessage;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.RpcFailure;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.server.MessageHandler;
import org.apache.celeborn.shaded.com.google.common.base.Throwables;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.apache.celeborn.shaded.io.netty.channel.ChannelFuture;
import org.apache.celeborn.shaded.io.netty.util.concurrent.Future;
import org.apache.celeborn.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRequestHandler
extends MessageHandler<RequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(TransportRequestHandler.class);
    private final Channel channel;
    private final TransportClient reverseClient;
    private final BaseMessageHandler msgHandler;

    public TransportRequestHandler(Channel channel, TransportClient reverseClient, BaseMessageHandler msgHandler) {
        this.channel = channel;
        this.reverseClient = reverseClient;
        this.msgHandler = msgHandler;
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        this.msgHandler.exceptionCaught(cause, this.reverseClient);
    }

    @Override
    public void channelActive() {
        this.msgHandler.channelActive(this.reverseClient);
    }

    @Override
    public void channelInactive() {
        this.msgHandler.channelInactive(this.reverseClient);
    }

    @Override
    public void handle(RequestMessage request) {
        if (this.checkRegistered(request)) {
            this.msgHandler.receive(this.reverseClient, request);
        }
    }

    private boolean checkRegistered(RequestMessage req) {
        if (!this.msgHandler.checkRegistered()) {
            IOException e = new IOException("Worker Not Registered!");
            if (req instanceof RpcRequest) {
                this.respond(new RpcFailure(((RpcRequest)req).requestId, Throwables.getStackTraceAsString(e)));
            } else if (req instanceof ChunkFetchRequest) {
                this.respond(new ChunkFetchFailure(((ChunkFetchRequest)req).streamChunkSlice, Throwables.getStackTraceAsString(e)));
            } else if (req instanceof OneWayMessage) {
                logger.warn("Ignore OneWayMessage since worker is not registered!");
            }
            return false;
        }
        return true;
    }

    private ChannelFuture respond(Encodable result) {
        SocketAddress remoteAddress = this.channel.remoteAddress();
        return this.channel.writeAndFlush(result).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (future.isSuccess()) {
                logger.trace("Sent result {} to client {}", (Object)result, (Object)remoteAddress);
            } else {
                logger.warn(String.format("Fail to sending result %s to %s; closing connection", result, remoteAddress), future.cause());
            }
        }));
    }
}

