/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.webapp;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public class ClasspathPattern
extends AbstractList<String> {
    private final List<Entry> _entries = new ArrayList<Entry>();

    public ClasspathPattern() {
    }

    public ClasspathPattern(String[] patterns) {
        this.setAll(patterns);
    }

    public ClasspathPattern(String pattern) {
        this.add(pattern);
    }

    @Override
    public String get(int index) {
        return this._entries.get((int)index)._pattern;
    }

    @Override
    public String set(int index, String element) {
        Entry e = this._entries.set(index, new Entry(element));
        return e == null ? null : e._pattern;
    }

    @Override
    public void add(int index, String element) {
        this._entries.add(index, new Entry(element));
    }

    @Deprecated
    public void addPattern(String element) {
        this.add(element);
    }

    @Override
    public String remove(int index) {
        Entry e = this._entries.remove(index);
        return e == null ? null : e._pattern;
    }

    public boolean remove(String pattern) {
        int i = this._entries.size();
        while (i-- > 0) {
            if (!pattern.equals(this._entries.get((int)i)._pattern)) continue;
            this._entries.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this._entries.size();
    }

    private void setAll(String[] classes) {
        this._entries.clear();
        this.addAll(classes);
    }

    private void addAll(String[] classes) {
        if (classes != null) {
            this.addAll(Arrays.asList(classes));
        }
    }

    public void prepend(String[] classes) {
        if (classes != null) {
            int i = 0;
            for (String c : classes) {
                this.add(i, c);
                ++i;
            }
        }
    }

    public void prependPattern(String pattern) {
        this.add(0, pattern);
    }

    public String[] getPatterns() {
        return this.toArray(new String[this._entries.size()]);
    }

    public List<String> getClasses() {
        ArrayList<String> list = new ArrayList<String>();
        for (Entry e : this._entries) {
            if (!e._inclusive || e._package) continue;
            list.add(e._name);
        }
        return list;
    }

    public boolean match(String name) {
        name = name.replace('/', '.');
        for (Entry entry : this._entries) {
            if (entry == null) continue;
            if (entry._package) {
                if (!name.startsWith(entry._name) && !".".equals(entry._pattern)) continue;
                return entry._inclusive;
            }
            if (name.equals(entry._name)) {
                return entry._inclusive;
            }
            if (name.length() <= entry._name.length() || '$' != name.charAt(entry._name.length()) || !name.startsWith(entry._name)) continue;
            return entry._inclusive;
        }
        return false;
    }

    public void addAfter(String afterPattern, String ... patterns) {
        if (patterns != null && afterPattern != null) {
            ListIterator<String> iter = this.listIterator();
            while (iter.hasNext()) {
                String cc = (String)iter.next();
                if (!afterPattern.equals(cc)) continue;
                for (int i = 0; i < patterns.length; ++i) {
                    iter.add(patterns[i]);
                }
                return;
            }
        }
        throw new IllegalArgumentException("after '" + afterPattern + "' not found in " + this);
    }

    public void addBefore(String beforePattern, String ... patterns) {
        if (patterns != null && beforePattern != null) {
            ListIterator<String> iter = this.listIterator();
            while (iter.hasNext()) {
                String cc = (String)iter.next();
                if (!beforePattern.equals(cc)) continue;
                iter.previous();
                for (int i = 0; i < patterns.length; ++i) {
                    iter.add(patterns[i]);
                }
                return;
            }
        }
        throw new IllegalArgumentException("before '" + beforePattern + "' not found in " + this);
    }

    private static class Entry {
        public final String _pattern;
        public final String _name;
        public final boolean _inclusive;
        public final boolean _package;

        Entry(String pattern) {
            this._pattern = pattern;
            this._inclusive = !pattern.startsWith("-");
            this._package = pattern.endsWith(".");
            this._name = this._inclusive ? pattern : pattern.substring(1).trim();
        }

        public String toString() {
            return this._pattern;
        }
    }
}

