/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.util.Util;

public class Invocation {
    private WeakReference<?> target;
    private Method method;
    private Class<?>[] parameterTypes;
    private int hashCode;

    private Invocation() {
    }

    public Invocation(Object target, String methodName) throws NoSuchMethodException {
        this(target, methodName, (Class[])null);
    }

    public Invocation(Object target, String methodName, Class parameterType) throws NoSuchMethodException {
        this(target, methodName, new Class[]{parameterType});
    }

    public Invocation(Object target, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        if (target == null) {
            throw new IllegalArgumentException("target argument must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("method name must not be null");
        }
        if (parameterTypes != null) {
            if (parameterTypes.length > 0) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i] != null) continue;
                    throw new IllegalArgumentException("parameter type[" + i + "] must not be null");
                }
            } else {
                throw new IllegalArgumentException("parameter types must not be empty");
            }
        }
        this.method = this.lookupMethodInHierarchy(target.getClass(), methodName, parameterTypes);
        if (this.method == null) {
            throw new NoSuchMethodException("No such method: " + target.getClass().getName() + "." + methodName);
        }
        if (!Util.isAccessible(this.method)) {
            this.method.setAccessible(true);
        }
        this.hashCode = 31 * target.hashCode() + this.method.hashCode();
        this.parameterTypes = parameterTypes;
        this.target = new WeakReference<Object>(target);
    }

    Method lookupMethodInHierarchy(Class<?> objectClass, String methodName, Class[] parameterTypes) throws SecurityException, NoSuchMethodException {
        try {
            return objectClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = objectClass.getSuperclass();
            if (superClass == null || superClass.getName().equals(Object.class.getName())) {
                throw e;
            }
            return this.lookupMethodInHierarchy(superClass, methodName, parameterTypes);
        }
    }

    public boolean fire() {
        return this.fire(null);
    }

    public boolean fire(Object argument) {
        return this.fire(new Object[]{argument});
    }

    public boolean fire(Object[] arguments) {
        Object currentTarget;
        if (this.parameterTypes == null) {
            if (arguments != null) {
                throw new IllegalArgumentException("arguments unexpectedly != null");
            }
        } else {
            if (arguments == null) {
                throw new IllegalArgumentException("arguments must not be null");
            }
            if (this.parameterTypes.length != arguments.length) {
                throw new IllegalArgumentException("inconsistent number of arguments: expected" + this.parameterTypes.length + ", got " + arguments.length);
            }
        }
        if ((currentTarget = this.target.get()) == null) {
            return false;
        }
        try {
            this.method.invoke(currentTarget, arguments);
            return true;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new CayenneRuntimeException(cause);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Invocation otherInvocation = (Invocation)obj;
        if (!this.method.equals(otherInvocation.getMethod())) {
            return false;
        }
        Object otherTarget = otherInvocation.getTarget();
        Object target = this.getTarget();
        if (target == otherTarget) {
            return true;
        }
        if (target == null) {
            return false;
        }
        return target.equals(otherTarget);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target.get();
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }
}

