/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.AbstractCallback;
import org.apache.cayenne.util.Util;

class CallbackOnListener
extends AbstractCallback {
    private Method callbackMethod;
    private Object listener;

    CallbackOnListener(Object listener, String methodName) throws IllegalArgumentException {
        this(listener, methodName, Object.class);
    }

    CallbackOnListener(Object listener, String methodName, Class<?> entityType) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        this.callbackMethod = this.findMethod(listener.getClass(), methodName, entityType);
        this.listener = listener;
    }

    CallbackOnListener(Object listener, Method method, Class<?> entityType) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        if (!this.verifyMethod(method, entityType)) {
            throw new IllegalArgumentException("Invalid annotated listener method: " + method.getName());
        }
        this.callbackMethod = method;
        this.listener = listener;
    }

    @Override
    public void performCallback(Object entity) {
        try {
            this.callbackMethod.invoke(this.listener, entity);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error invoking entity listener callback method " + this.callbackMethod.getName(), (Throwable)e, new Object[0]);
        }
    }

    public String toString() {
        return "callback-listener: " + this.callbackMethod.getDeclaringClass().getName() + "." + this.callbackMethod.getName();
    }

    private boolean verifyMethod(Method method, Class<?> entityType) {
        int modifiers = method.getModifiers();
        Class<?>[] parameters = method.getParameterTypes();
        if (!Modifier.isStatic(modifiers) && Void.TYPE.isAssignableFrom(method.getReturnType()) && parameters.length == 1 && parameters[0].isAssignableFrom(entityType)) {
            if (!Util.isAccessible(method)) {
                method.setAccessible(true);
            }
            return true;
        }
        return false;
    }

    private Method findMethod(Class<?> objectClass, String methodName, Class<?> entityType) throws IllegalArgumentException {
        Method[] methods;
        for (Method method : methods = objectClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName()) || !this.verifyMethod(method, entityType)) continue;
            return method;
        }
        Class<?> superclass = objectClass.getSuperclass();
        if (superclass == null || "java.lang.Object".equals(superclass.getName())) {
            throw new IllegalArgumentException("Class " + objectClass.getName() + " has no valid listener callback method '" + methodName + "'");
        }
        return this.findMethod(superclass, methodName, entityType);
    }
}

