/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Map;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.project.validation.BaseQueryValidator;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class SQLTemplateValidator
extends BaseQueryValidator {
    SQLTemplateValidator() {
    }

    void validate(SQLTemplateDescriptor query, ValidationResult validationResult) {
        this.validateName(query, validationResult);
        this.validateRoot(query, validationResult);
        this.validateDefaultSQL(query, validationResult);
        this.validateCacheGroup(query, validationResult);
    }

    void validateDefaultSQL(SQLTemplateDescriptor query, ValidationResult validationResult) {
        if (Util.isEmptyString(query.getSql())) {
            for (Map.Entry<String, String> entry : query.getAdapterSql().entrySet()) {
                if (Util.isEmptyString(entry.getValue())) continue;
                return;
            }
            this.addFailure(validationResult, query, "SQLTemplate query '%s' has no default SQL template", query.getName());
        }
    }

    void validateRoot(QueryDescriptor query, ValidationResult validationResult) {
        DataMap map = query.getDataMap();
        if (query.getRoot() == null && map != null) {
            this.addFailure(validationResult, query, "SQLTemplate query '%s' has no root", query.getName());
        }
    }
}

