/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.combo;

import java.awt.Color;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicComboPopup;
import org.apache.cayenne.modeler.util.CellRenderers;

public class SuggestionList
extends BasicComboPopup {
    protected boolean strict;

    public SuggestionList(JComboBox cb) {
        this(cb, false);
    }

    public SuggestionList(JComboBox cb, boolean strict) {
        super(cb);
        this.strict = strict;
        this.list.addMouseListener(new MouseHandler());
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
    }

    public void filter(String prefix) {
        ComboBoxModel model = this.comboBox.getModel();
        DefaultListModel lm = new DefaultListModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String item = CellRenderers.asString(model.getElementAt(i));
            if (!this.matches(item, prefix)) continue;
            lm.addElement(model.getElementAt(i));
        }
        this.list.setModel(lm);
    }

    protected boolean matches(String item, String pattern) {
        if (this.strict) {
            return item.toLowerCase().startsWith(pattern.toLowerCase());
        }
        return item.toLowerCase().contains(pattern.toLowerCase());
    }

    @Override
    protected int getPopupHeightForRowCount(int maxRowCount) {
        return super.getPopupHeightForRowCount(Math.min(maxRowCount, this.list.getModel().getSize()));
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public void setSelectedIndex(int i) {
        this.list.setSelectedIndex(i);
        this.comboBox.setSelectedItem(this.list.getModel().getElementAt(i));
    }

    public int getItemCount() {
        return this.list.getModel().getSize();
    }

    public Object getItemAt(int i) {
        return this.list.getModel().getElementAt(i);
    }

    @Override
    public MouseListener createListMouseListener() {
        return new MouseHandler();
    }

    @Override
    protected ItemListener createItemListener() {
        return e -> {};
    }

    public boolean isStrict() {
        return this.strict;
    }

    protected class MouseHandler
    extends MouseInputAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SuggestionList.this.comboBox.setSelectedItem(SuggestionList.this.list.getSelectedValue());
            SuggestionList.this.comboBox.setPopupVisible(false);
            if (SuggestionList.this.comboBox.isEditable() && SuggestionList.this.comboBox.getEditor() != null) {
                SuggestionList.this.comboBox.configureEditor(SuggestionList.this.comboBox.getEditor(), SuggestionList.this.comboBox.getSelectedItem());
            }
            SuggestionList.this.hide();
        }
    }
}

