/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen.property;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.cayenne.exp.property.DateProperty;
import org.apache.cayenne.gen.PropertyDescriptor;
import org.apache.cayenne.gen.property.PropertyDescriptorCreator;

public class DatePropertyDescriptorCreator
implements PropertyDescriptorCreator {
    private static final List<Class<?>> JAVA_DATE_TYPES = Arrays.asList(Date.class, LocalDate.class, LocalTime.class, LocalDateTime.class, java.sql.Date.class, Time.class, Timestamp.class);
    private static final String FACTORY_METHOD = "PropertyFactory.createDate";

    @Override
    public Optional<PropertyDescriptor> apply(Class<?> aClass) {
        if (JAVA_DATE_TYPES.contains(aClass)) {
            return Optional.of(new PropertyDescriptor(DateProperty.class.getName(), FACTORY_METHOD));
        }
        return Optional.empty();
    }
}

