/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.map.Entity;

public class OraclePkGenerator
extends JdbcPkGenerator {
    private static final String _SEQUENCE_PREFIX = "pk_";

    public OraclePkGenerator() {
    }

    protected OraclePkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    @Override
    public void createAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        List<String> sequences = this.getExistingSequences(node);
        for (DbEntity dbEntity : dbEntities) {
            if (sequences.contains(this.sequenceName(dbEntity))) continue;
            this.runUpdate(node, this.createSequenceString(dbEntity));
        }
    }

    @Override
    public List<String> createAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(dbEntities.size());
        for (DbEntity dbEntity : dbEntities) {
            list.add(this.createSequenceString(dbEntity));
        }
        return list;
    }

    @Override
    public void dropAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        List<String> sequences = this.getExistingSequences(node);
        for (DbEntity dbEntity : dbEntities) {
            String name;
            if (dbEntity.getDataMap().isQuotingSQLIdentifiers()) {
                DbEntity tempEnt = new DbEntity();
                DataMap dm = new DataMap();
                dm.setQuotingSQLIdentifiers(false);
                tempEnt.setDataMap(dm);
                tempEnt.setName(dbEntity.getName());
                name = this.stripSchemaName(this.sequenceName(tempEnt));
            } else {
                name = this.stripSchemaName(this.sequenceName(dbEntity));
            }
            if (!sequences.contains(name)) continue;
            this.runUpdate(node, this.dropSequenceString(dbEntity));
        }
    }

    @Override
    public List<String> dropAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(dbEntities.size());
        for (DbEntity dbEntity : dbEntities) {
            list.add(this.dropSequenceString(dbEntity));
        }
        return list;
    }

    protected String createSequenceString(DbEntity ent) {
        return "CREATE SEQUENCE " + this.sequenceName(ent) + " START WITH " + this.pkStartValue + " INCREMENT BY " + this.pkCacheSize(ent);
    }

    protected String dropSequenceString(DbEntity ent) {
        return "DROP SEQUENCE " + this.sequenceName(ent);
    }

    protected String selectNextValQuery(String pkGeneratingSequenceName) {
        return "SELECT " + pkGeneratingSequenceName + ".nextval FROM DUAL";
    }

    protected String selectAllSequencesQuery() {
        return "SELECT LOWER(SEQUENCE_NAME) FROM ALL_SEQUENCES";
    }

    /*
     * Exception decompiling
     */
    @Override
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int pkCacheSize(DbEntity entity) {
        DbKeyGenerator keyGenerator = entity.getPrimaryKeyGenerator();
        if (keyGenerator != null && "ORACLE".equals(keyGenerator.getGeneratorType()) && keyGenerator.getGeneratorName() != null) {
            Integer size = keyGenerator.getKeyCacheSize();
            return size != null && size >= 1 ? size.intValue() : this.getPkCacheSize();
        }
        return this.getPkCacheSize();
    }

    protected String sequenceName(DbEntity entity) {
        DbKeyGenerator keyGenerator = entity.getPrimaryKeyGenerator();
        if (keyGenerator != null && "ORACLE".equals(keyGenerator.getGeneratorType()) && keyGenerator.getGeneratorName() != null) {
            return keyGenerator.getGeneratorName().toLowerCase();
        }
        String seqName = this.getSequencePrefix() + entity.getName().toLowerCase();
        return this.adapter.getQuotingStrategy().quotedIdentifier((Entity)entity, entity.getCatalog(), entity.getSchema(), seqName);
    }

    protected String getSequencePrefix() {
        return _SEQUENCE_PREFIX;
    }

    private String stripSchemaName(String sequenceName) {
        int ind = sequenceName.indexOf(46);
        return ind >= 0 ? sequenceName.substring(ind + 1) : sequenceName;
    }

    /*
     * Exception decompiling
     */
    protected List<String> getExistingSequences(DataNode node) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

