/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.ValueEncryptor;

class DefaultValueEncryptor
implements ValueEncryptor {
    private BytesConverter preConverter;
    private BytesConverter postConverter;

    public DefaultValueEncryptor(BytesConverter preConverter, BytesConverter postConverter) {
        this.preConverter = preConverter;
        this.postConverter = postConverter;
    }

    BytesConverter getPreConverter() {
        return this.preConverter;
    }

    BytesConverter getPostConverter() {
        return this.postConverter;
    }

    @Override
    public Object encrypt(BytesEncryptor encryptor, Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = this.preConverter.toBytes(value);
        byte[] transformed = encryptor.encrypt(bytes, 0, new byte[1]);
        return this.postConverter.fromBytes(transformed);
    }
}

