/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.cayenne.crypto.CayenneCryptoException;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;

class CbcDecryptor
implements BytesDecryptor {
    private Cipher cipher;
    private int blockSize;

    CbcDecryptor(Cipher cipher) {
        this.cipher = cipher;
        this.blockSize = cipher.getBlockSize();
    }

    @Override
    public byte[] decrypt(byte[] input, int inputOffset, Key key) {
        try {
            return this.doDecrypt(input, inputOffset, key);
        }
        catch (Exception e) {
            throw new CayenneCryptoException("Error on decryption", e, new Object[0]);
        }
    }

    private byte[] doDecrypt(byte[] input, int inputOffset, Key key) throws InvalidKeyException, InvalidAlgorithmParameterException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        IvParameterSpec iv = this.iv(input, inputOffset);
        this.cipher.init(2, key, iv);
        int offset = inputOffset + this.blockSize;
        return this.cipher.doFinal(input, offset, input.length - offset);
    }

    IvParameterSpec iv(byte[] input, int inputOffset) {
        return new IvParameterSpec(input, inputOffset, this.blockSize);
    }
}

