/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer;

import java.util.Map;
import org.apache.cayenne.crypto.transformer.MapTransformer;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;
import org.apache.cayenne.crypto.transformer.value.ValueDecryptor;

public class DefaultMapTransformer
implements MapTransformer {
    private String[] mapKeys;
    private ValueDecryptor[] transformers;
    private BytesDecryptor bytesDecryptor;

    public DefaultMapTransformer(String[] mapKeys, ValueDecryptor[] transformers, BytesDecryptor bytesDecryptor) {
        this.mapKeys = mapKeys;
        this.transformers = transformers;
        this.bytesDecryptor = bytesDecryptor;
    }

    @Override
    public void transform(Map<String, Object> map) {
        int len = this.mapKeys.length;
        for (int i = 0; i < len; ++i) {
            Object value = map.get(this.mapKeys[i]);
            if (value == null) continue;
            Object transformed = this.transformers[i].decrypt(this.bytesDecryptor, value);
            map.put(this.mapKeys[i], transformed);
        }
    }
}

