/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class SerializationUtils {
    private static final Kryo KRYO = new Kryo();

    private SerializationUtils() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static void register(Class<?> type, Serializer<?> serializer) {
        KRYO.register(type, serializer);
    }

    public static byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream arOut = new ByteArrayOutputStream(512);
            try (ObjectOutputStream out = new ObjectOutputStream(arOut);){
                out.writeObject(object);
            }
            return arOut.toByteArray();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T> T deserialize(byte[] bytes, Class<T> type) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return type.cast(in.readObject());
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Output kryoSerialize(Object object) {
        try (Output out = new Output(1024, -1);){
            KRYO.writeObject(out, object);
            Output output = out;
            return output;
        }
    }

    public static <T> T kryoDeserialize(Output out, Class<T> type) {
        try (Input in = new Input(out.getBuffer(), 0, out.position());){
            Object object = KRYO.readObject(in, type);
            return (T)object;
        }
    }
}

