/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleNameGenerator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.quicktheories.QuickTheory;
import org.quicktheories.generators.SourceDSL;

class BundleNameGeneratorTest {
    BundleNameGeneratorTest() {
    }

    @Test
    void testNameGenerated() {
        String jobId = "ea3b3e6b-0d78-4913-89f2-15fcf98711d0";
        String sessionId = "1-9062a40b-41ae-40b0-8ba6-47f9bbec6cba";
        BundleNameGenerator nameGenerator = new BundleNameGenerator(jobId, sessionId);
        String expectedName = "b_" + jobId + "_" + sessionId + "_1_3";
        Assertions.assertThat((String)nameGenerator.generate(BigInteger.valueOf(1L), BigInteger.valueOf(3L))).isEqualTo(expectedName);
        expectedName = "d_" + jobId + "_" + sessionId + "_3_6";
        Assertions.assertThat((String)nameGenerator.generate(BigInteger.valueOf(3L), BigInteger.valueOf(6L))).isEqualTo(expectedName);
    }

    @Test
    void testAllStartCharsGenerated() {
        String jobId = "ea3b3e6b-0d78-4913-89f2-15fcf98711d0";
        char[] expectedResults = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        String sessionId = "1-9062a40b-41ae-40b0-8ba6-47f9bbec6cba";
        BundleNameGenerator nameGenerator = new BundleNameGenerator(jobId, sessionId);
        for (int i = 0; i < 62; ++i) {
            Assertions.assertThat((char)nameGenerator.generate(BigInteger.valueOf(i), BigInteger.valueOf(i + 1)).charAt(0)).isEqualTo(expectedResults[i]);
        }
    }

    @Test
    void testGenerateValidBundleNamePrefixChar() {
        QuickTheory.qt().withTestingTime(5L, TimeUnit.SECONDS).withUnlimitedExamples().forAll(SourceDSL.integers().all()).checkAssert(i -> {
            char prefix = BundleNameGenerator.generatePrefixChar((int)i);
            ((AbstractBooleanAssert)Assertions.assertThat((prefix >= 'a' && prefix <= 'z' || prefix >= 'A' && prefix <= 'Z' || prefix >= '0' && prefix <= '9' ? 1 : 0) != 0).as("Seed " + i + " produces invalid prefix " + prefix, new Object[0])).isTrue();
        });
    }
}

