/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.kafka;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.spark.utils.ArrayUtils;

public interface TopicSupplier {
    public String topic(CdcEvent var1);

    public static StaticTopicSupplier staticTopicSupplier(String topic) {
        return new StaticTopicSupplier(topic);
    }

    public static PerKeyspace keyspaceSupplier(String format) {
        return new PerKeyspace(format);
    }

    public static PerKeyspaceTable keyspaceTableSupplier(String format) {
        return new PerKeyspaceTable(format);
    }

    public static PerTable tableSupplier(String format) {
        return new PerTable(format);
    }

    public static MapTopicSupplier mapSupplier(String format) {
        return new MapTopicSupplier(format);
    }

    public static class MapTopicSupplier
    implements TopicSupplier {
        private final Map<String, String> topicsMap;

        MapTopicSupplier(String topicsMapString) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.topicsMap = (Map)mapper.readValue(topicsMapString, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String topic(CdcEvent event) {
            return this.topicsMap.get(event.keyspace + "." + event.table);
        }
    }

    public static class StaticTopicSupplier
    implements TopicSupplier {
        private final String topic;

        StaticTopicSupplier(String topic) {
            this.topic = topic;
        }

        @Override
        public String topic(CdcEvent event) {
            return this.topic;
        }
    }

    public static class PerTable
    extends StringFormatTopicSupplier {
        protected PerTable(String format) {
            super(format);
        }

        @Override
        protected List<String> args(CdcEvent event) {
            return ArrayUtils.listOf((Object[])new String[]{event.table});
        }
    }

    public static class PerKeyspaceTable
    extends StringFormatTopicSupplier {
        protected PerKeyspaceTable(String format) {
            super(format);
        }

        @Override
        protected List<String> args(CdcEvent event) {
            return ArrayUtils.listOf((Object[])new String[]{event.keyspace, event.table});
        }
    }

    public static class PerKeyspace
    extends StringFormatTopicSupplier {
        protected PerKeyspace(String format) {
            super(format);
        }

        @Override
        protected List<String> args(CdcEvent event) {
            return ArrayUtils.listOf((Object[])new String[]{event.keyspace});
        }
    }

    public static abstract class StringFormatTopicSupplier
    implements TopicSupplier {
        protected final String format;
        protected ThreadLocal<Map<List<String>, String>> cache = ThreadLocal.withInitial(HashMap::new);

        protected StringFormatTopicSupplier(String format) {
            this.format = format;
        }

        protected abstract List<String> args(CdcEvent var1);

        @Override
        public String topic(CdcEvent event) {
            return this.cache.get().computeIfAbsent(this.args(event), args -> String.format(this.format, args.toArray()));
        }
    }
}

