/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.SimilarityBase;

public class BasicModelIn
extends BasicModel {
    @Override
    public final double score(BasicStats stats, double tfn, double aeTimes1pTfn) {
        long N2 = stats.getNumberOfDocuments();
        long n = stats.getDocFreq();
        double A2 = SimilarityBase.log2((double)(N2 + 1L) / ((double)n + 0.5));
        return A2 * aeTimes1pTfn * (1.0 - 1.0 / (1.0 + tfn));
    }

    @Override
    public final Explanation explain(BasicStats stats, double tfn, double aeTimes1pTfn) {
        return Explanation.match((Number)Float.valueOf((float)(this.score(stats, tfn, aeTimes1pTfn) * (1.0 + tfn) / aeTimes1pTfn)), this.getClass().getSimpleName() + ", computed as tfn * log2((N + 1) / (n + 0.5)) from:", Explanation.match((Number)Float.valueOf((float)tfn), "tfn, normalized term frequency", new Explanation[0]), Explanation.match((Number)stats.getNumberOfDocuments(), "N, total number of documents with field", new Explanation[0]), Explanation.match((Number)stats.getDocFreq(), "n, number of documents containing term", new Explanation[0]));
    }

    @Override
    public String toString() {
        return "I(n)";
    }
}

