/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.apache.cassandra.repair.consistent.admin.CleanupSummary;
import org.apache.cassandra.repair.consistent.admin.PendingStats;
import org.apache.cassandra.repair.consistent.admin.RepairStats;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.utils.FBUtilities;

public abstract class RepairAdmin
extends NodeTool.NodeToolCmd {
    private static void printTable(List<List<String>> rows, PrintStream out) {
        if (rows.isEmpty()) {
            return;
        }
        int[] widths = new int[rows.get(0).size()];
        for (List<String> row : rows) {
            assert (row.size() == widths.length);
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = Math.max(widths[i], row.get(i).length());
            }
        }
        ArrayList<CallSite> fmts = new ArrayList<CallSite>(widths.length);
        for (int i = 0; i < widths.length; ++i) {
            fmts.add((CallSite)((Object)("%-" + widths[i] + "s")));
        }
        for (List<String> row : rows) {
            ArrayList<String> formatted = new ArrayList<String>(row.size());
            for (int i = 0; i < widths.length; ++i) {
                formatted.add(String.format((String)fmts.get(i), row.get(i)));
            }
            out.println(Joiner.on(" | ").join(formatted));
        }
    }

    static String getRangeString(String startToken, String endToken) {
        String rangeStr = null;
        if (!startToken.isEmpty() || !endToken.isEmpty()) {
            rangeStr = startToken + ":" + endToken;
        }
        return rangeStr;
    }

    @Command(name="cancel", description="cancel an incremental repair session. Use --force to cancel from a node other than the repair coordinator Attempting to cancel FINALIZED or FAILED sessions is an error.")
    public static class CancelCmd
    extends RepairAdmin {
        @Option(title="force", name={"-f", "--force"}, description="Force a cancellation.")
        private boolean force = false;
        @Option(title="session", name={"-s", "--session"}, description="The session to cancel", required=true)
        private String sessionToCancel;

        @Override
        protected void execute(NodeProbe probe) {
            probe.getRepairServiceProxy().failSession(this.sessionToCancel, this.force);
        }
    }

    @Command(name="cleanup", description="cleans up pending data from completed sessions. This happens automatically, but the command is provided for situations where it needs to be expedited. Use --force to cancel compactions that are preventing promotion")
    public static class CleanupDataCmd
    extends RepairAdmin {
        @Option(title="force", name={"-f", "--force"}, description="Force a cleanup.")
        private boolean force = false;
        @Option(title="start_token", name={"-st", "--start-token"}, description="Use -st to specify a token at which the repair range starts")
        private String startToken = "";
        @Option(title="end_token", name={"-et", "--end-token"}, description="Use -et to specify a token at which repair range ends")
        private String endToken = "";
        @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
        private List<String> schemaArgs = new ArrayList<String>();

        @Override
        protected void execute(NodeProbe probe) {
            PrintStream out = probe.output().out;
            out.println("Cleaning up data from completed sessions...");
            List<CompositeData> compositeData = probe.getRepairServiceProxy().cleanupPending(this.schemaArgs, CleanupDataCmd.getRangeString(this.startToken, this.endToken), this.force);
            ArrayList summaries = new ArrayList(compositeData.size());
            compositeData.forEach(cd2 -> summaries.add(CleanupSummary.fromComposite(cd2)));
            summaries.sort((l, r) -> {
                int cmp = l.keyspace.compareTo(r.keyspace);
                if (cmp != 0) {
                    return cmp;
                }
                return l.table.compareTo(r.table);
            });
            ArrayList<String> header = Lists.newArrayList("keyspace", "table", "successful sessions", "unsuccessful sessions");
            ArrayList<List<String>> rows = new ArrayList<List<String>>(summaries.size() + 1);
            rows.add(header);
            boolean hasFailures = false;
            for (CleanupSummary summary : summaries) {
                ArrayList<String> row = Lists.newArrayList(summary.keyspace, summary.table, Integer.toString(summary.successful.size()), Integer.toString(summary.unsuccessful.size()));
                hasFailures |= !summary.unsuccessful.isEmpty();
                rows.add(row);
            }
            if (hasFailures) {
                out.println("Some tables couldn't be cleaned up completely");
            }
            RepairAdmin.printTable(rows, out);
        }
    }

    @Command(name="summarize-repaired", description="return the most recent repairedAt timestamp for the given token range (or all replicated ranges if no tokens are provided)")
    public static class SummarizeRepairedCmd
    extends RepairAdmin {
        @Option(title="verbose", name={"-v", "--verbose"}, description="print additional info ")
        private boolean verbose = false;
        @Option(title="start_token", name={"-st", "--start-token"}, description="Use -st to specify a token at which the repair range starts")
        private String startToken = "";
        @Option(title="end_token", name={"-et", "--end-token"}, description="Use -et to specify a token at which repair range ends")
        private String endToken = "";
        @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
        private List<String> schemaArgs = new ArrayList<String>();

        @Override
        protected void execute(NodeProbe probe) {
            PrintStream out = probe.output().out;
            List<CompositeData> compositeData = probe.getRepairServiceProxy().getRepairStats(this.schemaArgs, SummarizeRepairedCmd.getRangeString(this.startToken, this.endToken));
            if (compositeData.isEmpty()) {
                out.println("no stats");
                return;
            }
            ArrayList stats = new ArrayList(compositeData.size());
            compositeData.forEach(cd2 -> stats.add(RepairStats.fromComposite(cd2)));
            stats.sort((l, r) -> {
                int cmp = l.keyspace.compareTo(r.keyspace);
                if (cmp != 0) {
                    return cmp;
                }
                return l.table.compareTo(r.table);
            });
            ArrayList<String> header = Lists.newArrayList("keyspace", "table", "min_repaired", "max_repaired");
            if (this.verbose) {
                header.add("detail");
            }
            ArrayList<List<String>> rows = new ArrayList<List<String>>(stats.size() + 1);
            rows.add(header);
            for (RepairStats stat : stats) {
                ArrayList<String> row = Lists.newArrayList(stat.keyspace, stat.table, Long.toString(stat.minRepaired), Long.toString(stat.maxRepaired));
                if (this.verbose) {
                    row.add(Joiner.on(", ").join(Iterables.transform(stat.sections, RepairStats.Section::toString)));
                }
                rows.add(row);
            }
            RepairAdmin.printTable(rows, out);
        }
    }

    @Command(name="summarize-pending", description="report the amount of data marked pending repair for the given token range (or all replicated range if no tokens are provided")
    public static class SummarizePendingCmd
    extends RepairAdmin {
        @Option(title="verbose", name={"-v", "--verbose"}, description="print additional info ")
        private boolean verbose;
        @Option(title="start_token", name={"-st", "--start-token"}, description="Use -st to specify a token at which the repair range starts")
        private String startToken = "";
        @Option(title="end_token", name={"-et", "--end-token"}, description="Use -et to specify a token at which repair range ends")
        private String endToken = "";
        @Arguments(usage="[<keyspace> <tables>...]", description="The keyspace followed by one or many tables")
        private List<String> schemaArgs = new ArrayList<String>();

        @Override
        protected void execute(NodeProbe probe) {
            List<CompositeData> cds = probe.getRepairServiceProxy().getPendingStats(this.schemaArgs, SummarizePendingCmd.getRangeString(this.startToken, this.endToken));
            ArrayList stats = new ArrayList(cds.size());
            cds.forEach(cd2 -> stats.add(PendingStats.fromComposite(cd2)));
            stats.sort((l, r) -> {
                int cmp = l.keyspace.compareTo(r.keyspace);
                if (cmp != 0) {
                    return cmp;
                }
                return l.table.compareTo(r.table);
            });
            ArrayList<String> header = Lists.newArrayList("keyspace", "table", "total");
            if (this.verbose) {
                header.addAll(Lists.newArrayList("pending", "finalized", "failed"));
            }
            ArrayList<List<String>> rows = new ArrayList<List<String>>(stats.size() + 1);
            rows.add(header);
            for (PendingStats stat : stats) {
                ArrayList<String> row = new ArrayList<String>(header.size());
                row.add(stat.keyspace);
                row.add(stat.table);
                row.add(stat.total.sizeString());
                if (this.verbose) {
                    row.add(stat.pending.sizeString());
                    row.add(stat.finalized.sizeString());
                    row.add(stat.failed.sizeString());
                }
                rows.add(row);
            }
            RepairAdmin.printTable(rows, probe.output().out);
        }
    }

    @Command(name="list", description="list repair sessions")
    public static class ListCmd
    extends RepairAdmin {
        @Option(title="all", name={"-a", "--all"}, description="include completed and failed sessions")
        private boolean all;
        @Option(title="start_token", name={"-st", "--start-token"}, description="Use -st to specify a token at which the repair range starts")
        private String startToken = "";
        @Option(title="end_token", name={"-et", "--end-token"}, description="Use -et to specify a token at which repair range ends")
        private String endToken = "";

        @Override
        protected void execute(NodeProbe probe) {
            PrintStream out = probe.output().out;
            List<Map<String, String>> sessions = probe.getRepairServiceProxy().getSessions(this.all, ListCmd.getRangeString(this.startToken, this.endToken));
            if (sessions.isEmpty()) {
                out.println("no sessions");
            } else {
                ArrayList<List<String>> rows = new ArrayList<List<String>>();
                rows.add(Lists.newArrayList("id", "state", "last activity", "coordinator", "participants", "participants_wp"));
                long now = FBUtilities.nowInSeconds();
                for (Map<String, String> session : sessions) {
                    int updated = Integer.parseInt(session.get("LAST_UPDATE"));
                    ArrayList<String> values = Lists.newArrayList(session.get("SESSION_ID"), session.get("STATE"), now - (long)updated + " (s)", session.get("COORDINATOR"), session.get("PARTICIPANTS"), session.get("PARTICIPANTS_WP"));
                    rows.add(values);
                }
                RepairAdmin.printTable(rows, out);
            }
        }
    }
}

