/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InOurDc;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.Replicas;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.reads.repair.BlockingReadRepairs;
import org.apache.cassandra.service.reads.repair.ReadRepairDiagnostics;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.apache.cassandra.utils.concurrent.CountDownLatch;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

public class BlockingPartitionRepair
extends AsyncFuture<Object>
implements RequestCallback<Object> {
    private final DecoratedKey key;
    private final ReplicaPlan.ForWrite writePlan;
    private final Map<Replica, Mutation> pendingRepairs;
    private final CountDownLatch latch;
    private volatile long mutationsSentTime;

    public BlockingPartitionRepair(DecoratedKey key, Map<Replica, Mutation> repairs, ReplicaPlan.ForWrite writePlan) {
        this.key = key;
        this.pendingRepairs = new ConcurrentHashMap<Replica, Mutation>(repairs);
        this.writePlan = writePlan;
        Preconditions.checkState(Iterables.all(repairs.keySet(), r -> ((EndpointsForToken)writePlan.contacts()).contains((Replica)r)), "All repair targets should be part of contacts of read repair write plan.");
        int blockFor = writePlan.writeQuorum();
        for (Replica participant : (EndpointsForToken)writePlan.contacts()) {
            if (!repairs.containsKey(participant)) {
                --blockFor;
            }
            Preconditions.checkState(!writePlan.consistencyLevel().isDatacenterLocal() || InOurDc.replicas().test(participant), "Local consistency blocking read repair is trying to contact remote DC node: " + participant.endpoint());
        }
        this.latch = CountDownLatch.newCountDownLatch(Math.max(blockFor, 0));
    }

    int blockFor() {
        return this.writePlan.writeQuorum();
    }

    @VisibleForTesting
    int waitingOn() {
        return this.latch.count();
    }

    @VisibleForTesting
    void ack(InetAddressAndPort from) {
        this.pendingRepairs.remove(this.writePlan.lookup(from));
        this.latch.decrement();
    }

    @Override
    public void onResponse(Message<Object> msg) {
        this.ack(msg.from());
    }

    private static PartitionUpdate extractUpdate(Mutation mutation) {
        return (PartitionUpdate)Iterables.getOnlyElement(mutation.getPartitionUpdates());
    }

    private PartitionUpdate mergeUnackedUpdates() {
        ArrayList<PartitionUpdate> updates = Lists.newArrayList(Iterables.transform(this.pendingRepairs.values(), BlockingPartitionRepair::extractUpdate));
        return updates.isEmpty() ? null : PartitionUpdate.merge(updates);
    }

    @VisibleForTesting
    protected void sendRR(Message<Mutation> message, InetAddressAndPort endpoint) {
        MessagingService.instance().sendWithCallback(message, endpoint, (RequestCallback)this);
    }

    public void sendInitialRepairs() {
        this.mutationsSentTime = Clock.Global.nanoTime();
        Replicas.assertFull(this.pendingRepairs.keySet());
        for (Map.Entry<Replica, Mutation> entry : this.pendingRepairs.entrySet()) {
            Replica destination = entry.getKey();
            Preconditions.checkArgument(destination.isFull(), "Can't send repairs to transient replicas: %s", (Object)destination);
            Mutation mutation = entry.getValue();
            TableId tableId = BlockingPartitionRepair.extractUpdate((Mutation)mutation).metadata().id;
            Tracing.trace("Sending read-repair-mutation to {}", (Object)destination);
            this.sendRR(Message.out(Verb.READ_REPAIR_REQ, mutation), destination.endpoint());
            ColumnFamilyStore.metricsFor((TableId)tableId).readRepairRequests.mark();
            ReadRepairDiagnostics.sendInitialRepair(this, destination.endpoint(), mutation);
        }
    }

    public boolean awaitRepairsUntil(long timeoutAt, TimeUnit timeUnit) {
        long timeoutAtNanos = timeUnit.toNanos(timeoutAt);
        long remaining = timeoutAtNanos - Clock.Global.nanoTime();
        try {
            return this.latch.await(remaining, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }

    private static int msgVersionIdx(int version) {
        return version - 12;
    }

    public void maybeSendAdditionalWrites(long timeout, TimeUnit timeoutUnit) {
        EndpointsForToken newCandidates;
        if (this.awaitRepairsUntil(timeout + timeoutUnit.convert(this.mutationsSentTime, TimeUnit.NANOSECONDS), timeoutUnit)) {
            return;
        }
        EndpointsForToken endpointsForToken = newCandidates = this.writePlan.consistencyLevel().isDatacenterLocal() ? (EndpointsForToken)this.writePlan.liveUncontacted().filter(InOurDc.replicas()) : this.writePlan.liveUncontacted();
        if (newCandidates.isEmpty()) {
            return;
        }
        PartitionUpdate update = this.mergeUnackedUpdates();
        if (update == null) {
            return;
        }
        ReadRepairMetrics.speculatedWrite.mark();
        Mutation[] versionedMutations = new Mutation[BlockingPartitionRepair.msgVersionIdx(MessagingService.current_version) + 1];
        for (Replica replica : newCandidates) {
            int versionIdx = BlockingPartitionRepair.msgVersionIdx(MessagingService.instance().versions.get(replica.endpoint()));
            Mutation mutation = versionedMutations[versionIdx];
            if (mutation == null) {
                versionedMutations[versionIdx] = mutation = BlockingReadRepairs.createRepairMutation(update, this.writePlan.consistencyLevel(), replica.endpoint(), true);
            }
            if (mutation == null) {
                ReadRepairDiagnostics.speculatedWriteOversized(this, replica.endpoint());
                continue;
            }
            Tracing.trace("Sending speculative read-repair-mutation to {}", (Object)replica);
            this.sendRR(Message.out(Verb.READ_REPAIR_REQ, mutation), replica.endpoint());
            ReadRepairDiagnostics.speculatedWrite(this, replica.endpoint(), mutation);
        }
    }

    Keyspace getKeyspace() {
        return this.writePlan.keyspace();
    }

    DecoratedKey getKey() {
        return this.key;
    }

    ConsistencyLevel getConsistency() {
        return this.writePlan.consistencyLevel();
    }
}

