/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.Objects;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.TimeUUID;

public class CleanupMessage
extends RepairMessage {
    public final TimeUUID parentRepairSession;
    public static final IVersionedSerializer<CleanupMessage> serializer = new IVersionedSerializer<CleanupMessage>(){

        @Override
        public void serialize(CleanupMessage message, DataOutputPlus out, int version) throws IOException {
            message.parentRepairSession.serialize(out);
        }

        @Override
        public CleanupMessage deserialize(DataInputPlus in, int version) throws IOException {
            TimeUUID parentRepairSession = TimeUUID.deserialize(in);
            return new CleanupMessage(parentRepairSession);
        }

        @Override
        public long serializedSize(CleanupMessage message, int version) {
            return TimeUUID.sizeInBytes();
        }
    };

    public CleanupMessage(TimeUUID parentRepairSession) {
        super(null);
        this.parentRepairSession = parentRepairSession;
    }

    @Override
    public TimeUUID parentRepairSession() {
        return this.parentRepairSession;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CleanupMessage)) {
            return false;
        }
        CleanupMessage other = (CleanupMessage)o;
        return this.parentRepairSession.equals(other.parentRepairSession);
    }

    public int hashCode() {
        return Objects.hash(this.parentRepairSession);
    }
}

