/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;

public class CompactionMetrics {
    public static final MetricNameFactory factory = new DefaultNameFactory("Compaction");
    public final Gauge<Integer> pendingTasks = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PendingTasks"), new Gauge<Integer>(){

        @Override
        public Integer getValue() {
            int n = 0;
            for (String keyspaceName : Schema.instance.getKeyspaces()) {
                for (ColumnFamilyStore cfs : Keyspace.open(keyspaceName).getColumnFamilyStores()) {
                    n += cfs.getCompactionStrategyManager().getEstimatedRemainingTasks();
                }
            }
            return n + CompactionManager.instance.active.getCompactions().size();
        }
    });
    public final Gauge<Map<String, Map<String, Integer>>> pendingTasksByTableName = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("PendingTasksByTableName"), new Gauge<Map<String, Map<String, Integer>>>(){

        @Override
        public Map<String, Map<String, Integer>> getValue() {
            HashMap<String, Map<String, Integer>> resultMap = new HashMap<String, Map<String, Integer>>();
            for (String keyspaceName : Schema.instance.getKeyspaces()) {
                for (ColumnFamilyStore cfs : Keyspace.open(keyspaceName).getColumnFamilyStores()) {
                    int taskNumber = cfs.getCompactionStrategyManager().getEstimatedRemainingTasks();
                    if (taskNumber <= 0) continue;
                    if (!resultMap.containsKey(keyspaceName)) {
                        resultMap.put(keyspaceName, new HashMap());
                    }
                    ((Map)resultMap.get(keyspaceName)).put(cfs.getTableName(), taskNumber);
                }
            }
            for (CompactionInfo.Holder compaction : CompactionManager.instance.active.getCompactions()) {
                Map tableNameToCountMap;
                TableMetadata metaData = compaction.getCompactionInfo().getTableMetadata();
                if (metaData == null) continue;
                if (!resultMap.containsKey(metaData.keyspace)) {
                    resultMap.put(metaData.keyspace, new HashMap());
                }
                if ((tableNameToCountMap = (Map)resultMap.get(metaData.keyspace)).containsKey(metaData.name)) {
                    tableNameToCountMap.put(metaData.name, (Integer)tableNameToCountMap.get(metaData.name) + 1);
                    continue;
                }
                tableNameToCountMap.put(metaData.name, 1);
            }
            return resultMap;
        }
    });
    public final Gauge<Long> completedTasks;
    public final Meter totalCompactionsCompleted;
    public final Counter bytesCompacted;
    public final Timer indexSummaryRedistributionTime;
    public final Counter compactionsReduced;
    public final Counter sstablesDropppedFromCompactions;
    public final Counter compactionsAborted;

    public CompactionMetrics(final ExecutorPlus ... collectors) {
        this.completedTasks = CassandraMetricsRegistry.Metrics.register(factory.createMetricName("CompletedTasks"), new Gauge<Long>(){

            @Override
            public Long getValue() {
                long completedTasks = 0L;
                for (ExecutorPlus collector : collectors) {
                    completedTasks += collector.getCompletedTaskCount();
                }
                return completedTasks;
            }
        });
        this.totalCompactionsCompleted = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("TotalCompactionsCompleted"));
        this.bytesCompacted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("BytesCompacted"));
        this.compactionsReduced = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("CompactionsReduced"));
        this.sstablesDropppedFromCompactions = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("SSTablesDroppedFromCompaction"));
        this.compactionsAborted = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("CompactionsAborted"));
        this.indexSummaryRedistributionTime = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName("IndexSummaryRedistributionTime"));
    }
}

