/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.IVerifier;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SortedTableVerifier;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.IndexSummaryComponent;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.OutputHandler;

public class BigTableVerifier
extends SortedTableVerifier<BigTableReader>
implements IVerifier {
    public BigTableVerifier(ColumnFamilyStore cfs, BigTableReader sstable, OutputHandler outputHandler, boolean isOffline, IVerifier.Options options) {
        super(cfs, sstable, outputHandler, isOffline, options);
    }

    @Override
    protected void verifyPartition(DecoratedKey key, UnfilteredRowIterator iterator) {
        Row first = null;
        int duplicateRows = 0;
        long minTimestamp = Long.MAX_VALUE;
        long maxTimestamp = Long.MIN_VALUE;
        while (iterator.hasNext()) {
            Unfiltered uf = (Unfiltered)iterator.next();
            if (!uf.isRow()) continue;
            Row row = (Row)uf;
            if (first != null && first.clustering().equals(row.clustering())) {
                ++duplicateRows;
                for (Cell<?> cell : row.cells()) {
                    maxTimestamp = Math.max(cell.timestamp(), maxTimestamp);
                    minTimestamp = Math.min(cell.timestamp(), minTimestamp);
                }
                continue;
            }
            if (duplicateRows > 0) {
                this.logDuplicates(key, first, duplicateRows, minTimestamp, maxTimestamp);
            }
            duplicateRows = 0;
            first = row;
            maxTimestamp = Long.MIN_VALUE;
            minTimestamp = Long.MAX_VALUE;
        }
        if (duplicateRows > 0) {
            this.logDuplicates(key, first, duplicateRows, minTimestamp, maxTimestamp);
        }
    }

    private void verifyIndexSummary() {
        try {
            this.outputHandler.debug("Deserializing index summary for %s", this.sstable);
            this.deserializeIndexSummary(this.sstable);
        }
        catch (Throwable t2) {
            this.outputHandler.output("Index summary is corrupt - if it is removed it will get rebuilt on startup %s", ((BigTableReader)this.sstable).descriptor.fileFor(BigFormat.Components.SUMMARY));
            this.outputHandler.warn(t2);
            this.markAndThrow(t2, false);
        }
    }

    @Override
    protected void verifyIndex() {
        this.verifyIndexSummary();
        super.verifyIndex();
    }

    private void logDuplicates(DecoratedKey key, Row first, int duplicateRows, long minTimestamp, long maxTimestamp) {
        String keyString = ((BigTableReader)this.sstable).metadata().partitionKeyType.getString(key.getKey());
        long firstMaxTs = Long.MIN_VALUE;
        long firstMinTs = Long.MAX_VALUE;
        for (Cell<?> cell : first.cells()) {
            firstMaxTs = Math.max(firstMaxTs, cell.timestamp());
            firstMinTs = Math.min(firstMinTs, cell.timestamp());
        }
        this.outputHandler.output("%d duplicate rows found for [%s %s] in %s.%s (%s), timestamps: [first row (%s, %s)], [duplicates (%s, %s, eq:%b)]", duplicateRows, keyString, first.clustering().toString(((BigTableReader)this.sstable).metadata()), ((BigTableReader)this.sstable).metadata().keyspace, ((BigTableReader)this.sstable).metadata().name, this.sstable, this.dateString(firstMinTs), this.dateString(firstMaxTs), this.dateString(minTimestamp), this.dateString(maxTimestamp), minTimestamp == maxTimestamp);
    }

    private String dateString(long time) {
        return Instant.ofEpochMilli(TimeUnit.MICROSECONDS.toMillis(time)).toString();
    }

    private void deserializeIndexSummary(SSTableReader sstable) throws IOException {
        IndexSummaryComponent summaryComponent = IndexSummaryComponent.load(sstable.descriptor.fileFor(BigFormat.Components.SUMMARY), this.cfs.metadata());
        if (summaryComponent == null) {
            throw new NoSuchFileException("Index summary component of sstable " + sstable.descriptor + " is missing");
        }
        FileUtils.closeQuietly(summaryComponent.indexSummary);
    }
}

