/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableId;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.SSTableTxnWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.service.ActiveRepairService;

abstract class AbstractSSTableSimpleWriter
implements Closeable {
    protected final File directory;
    protected final TableMetadataRef metadata;
    protected final RegularAndStaticColumns columns;
    protected SSTableFormat<?, ?> format = DatabaseDescriptor.getSelectedSSTableFormat();
    protected static final AtomicReference<SSTableId> id = new AtomicReference<SSTableId>(SSTableIdFactory.instance.defaultBuilder().generator(Stream.empty()).get());
    protected boolean makeRangeAware = false;
    protected final Collection<Index.Group> indexGroups;
    protected Consumer<Collection<SSTableReader>> sstableProducedListener;
    protected boolean openSSTableOnProduced = false;

    protected AbstractSSTableSimpleWriter(File directory, TableMetadataRef metadata, RegularAndStaticColumns columns) {
        this.metadata = metadata;
        this.directory = directory;
        this.columns = columns;
        this.indexGroups = new ArrayList<Index.Group>();
    }

    protected void setSSTableFormatType(SSTableFormat<?, ?> type) {
        this.format = type;
    }

    protected void setRangeAwareWriting(boolean makeRangeAware) {
        this.makeRangeAware = makeRangeAware;
    }

    protected void addIndexGroup(Index.Group indexGroup) {
        this.indexGroups.add(indexGroup);
    }

    protected void setSSTableProducedListener(Consumer<Collection<SSTableReader>> listener) {
        this.sstableProducedListener = Objects.requireNonNull(listener);
    }

    protected void setShouldOpenProducedSSTable(boolean openSSTableOnProduced) {
        this.openSSTableOnProduced = openSSTableOnProduced;
    }

    protected boolean shouldOpenSSTables() {
        return this.openSSTableOnProduced;
    }

    protected void notifySSTableProduced(Collection<SSTableReader> sstables) {
        if (this.sstableProducedListener == null) {
            return;
        }
        this.sstableProducedListener.accept(sstables);
    }

    protected SSTableTxnWriter createWriter(SSTable.Owner owner) throws IOException {
        SerializationHeader header = new SerializationHeader(true, this.metadata.get(), this.columns, EncodingStats.NO_STATS);
        if (this.makeRangeAware) {
            return SSTableTxnWriter.createRangeAware(this.metadata, 0L, 0L, ActiveRepairService.NO_PENDING_REPAIR, false, this.format, header);
        }
        return SSTableTxnWriter.create(this.metadata, AbstractSSTableSimpleWriter.createDescriptor(this.directory, this.metadata.keyspace, this.metadata.name, this.format), 0L, 0L, ActiveRepairService.NO_PENDING_REPAIR, false, header, this.indexGroups, owner);
    }

    private static Descriptor createDescriptor(File directory, String keyspace, String columnFamily, SSTableFormat<?, ?> fmt) throws IOException {
        SSTableId nextGen = AbstractSSTableSimpleWriter.getNextId(directory, columnFamily);
        return new Descriptor(directory, keyspace, columnFamily, nextGen, fmt);
    }

    private static SSTableId getNextId(File directory, String columnFamily) throws IOException {
        while (true) {
            Stream<Path> existingPaths = Files.list(directory.toPath());
            try {
                SSTableId newId;
                Stream<SSTableId> existingIds = existingPaths.map(File::new).map(SSTable::tryDescriptorFromFile).filter(d -> d != null && d.cfname.equals(columnFamily)).map(d -> d.id);
                SSTableId lastId = id.get();
                if (!id.compareAndSet(lastId, newId = SSTableIdFactory.instance.defaultBuilder().generator(Stream.concat(existingIds, Stream.of(lastId))).get())) continue;
                SSTableId sSTableId = newId;
                return sSTableId;
            }
            finally {
                if (existingPaths == null) continue;
                existingPaths.close();
                continue;
            }
            break;
        }
    }

    PartitionUpdate.Builder getUpdateFor(ByteBuffer key) throws IOException {
        return this.getUpdateFor(this.metadata.get().partitioner.decorateKey(key));
    }

    abstract PartitionUpdate.Builder getUpdateFor(DecoratedKey var1) throws IOException;
}

