/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

public class TokenFct
extends NativeScalarFunction {
    private final TableMetadata metadata;

    public TokenFct(TableMetadata metadata) {
        super("token", metadata.partitioner.getTokenValidator(), TokenFct.getKeyTypes(metadata));
        this.metadata = metadata;
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        Object[] deserializers = new ArgumentDeserializer[this.argTypes.size()];
        Arrays.fill(deserializers, ArgumentDeserializer.NOOP_DESERIALIZER);
        return new FunctionArguments(version, (ArgumentDeserializer[])deserializers);
    }

    private static AbstractType<?>[] getKeyTypes(TableMetadata metadata) {
        AbstractType[] types = new AbstractType[metadata.partitionKeyColumns().size()];
        int i = 0;
        for (ColumnMetadata def : metadata.partitionKeyColumns()) {
            types[i++] = def.type;
        }
        return types;
    }

    @Override
    public ByteBuffer execute(Arguments arguments) throws InvalidRequestException {
        CBuilder builder = CBuilder.create(this.metadata.partitionKeyAsClusteringComparator());
        for (int i = 0; i < arguments.size(); ++i) {
            ByteBuffer bb = (ByteBuffer)arguments.get(i);
            if (bb == null) {
                return null;
            }
            builder.add(bb);
        }
        return this.metadata.partitioner.getTokenFactory().toByteArray(this.metadata.partitioner.getToken(builder.build().serializeAsPartitionKey()));
    }

    public static void addFunctionsTo(NativeFunctions functions) {
        functions.add(new FunctionFactory("token", new FunctionParameter[0]){

            @Override
            public NativeFunction getOrCreateFunction(List<? extends AssignmentTestable> args, AbstractType<?> receiverType, String receiverKeyspace, String receiverTable) {
                if (receiverKeyspace == null) {
                    throw new InvalidRequestException("No receiver keyspace has been specified for function " + this.name);
                }
                if (receiverTable == null) {
                    throw new InvalidRequestException("No receiver table has been specified for function " + this.name);
                }
                TableMetadata metadata = Schema.instance.getTableMetadata(receiverKeyspace, receiverTable);
                if (metadata == null) {
                    throw new InvalidRequestException(String.format("The receiver table %s.%s specified by call to function %s hasn't been found", receiverKeyspace, receiverTable, this.name));
                }
                return new TokenFct(metadata);
            }

            @Override
            protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
                throw new AssertionError((Object)"Should be unreachable");
            }
        });
    }
}

