/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncTask;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSyncTask
extends SyncTask
implements StreamEventHandler {
    private final TraceState state = Tracing.instance.get();
    private static final Logger logger = LoggerFactory.getLogger(LocalSyncTask.class);
    private final UUID pendingRepair;
    @VisibleForTesting
    public final boolean requestRanges;
    @VisibleForTesting
    public final boolean transferRanges;
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final CompletableFuture<StreamPlan> planFuture = new CompletableFuture();

    public LocalSyncTask(RepairJobDesc desc, InetAddressAndPort local, InetAddressAndPort remote, List<Range<Token>> diff, UUID pendingRepair, boolean requestRanges, boolean transferRanges, PreviewKind previewKind) {
        super(desc, local, remote, diff, previewKind);
        Preconditions.checkArgument(requestRanges || transferRanges, "Nothing to do in a sync job");
        Preconditions.checkArgument(local.equals(FBUtilities.getBroadcastAddressAndPort()));
        this.pendingRepair = pendingRepair;
        this.requestRanges = requestRanges;
        this.transferRanges = transferRanges;
    }

    @VisibleForTesting
    StreamPlan createStreamPlan() {
        InetAddressAndPort remote = this.nodePair.peer;
        StreamPlan plan = new StreamPlan(StreamOperation.REPAIR, 1, false, this.pendingRepair, this.previewKind).listeners(this, new StreamEventHandler[0]).flushBeforeTransfer(this.pendingRepair == null);
        if (this.requestRanges) {
            plan.requestRanges(remote, this.desc.keyspace, RangesAtEndpoint.toDummyList(this.rangesToSync), RangesAtEndpoint.toDummyList(Collections.emptyList()), this.desc.columnFamily);
        }
        if (this.transferRanges) {
            plan.transferRanges(remote, this.desc.keyspace, RangesAtEndpoint.toDummyList(this.rangesToSync), this.desc.columnFamily);
        }
        return plan;
    }

    @Override
    protected void startSync() {
        if (this.active.get()) {
            InetAddressAndPort remote = this.nodePair.peer;
            String message = String.format("Performing streaming repair of %d ranges with %s", this.rangesToSync.size(), remote);
            logger.info("{} {}", (Object)this.previewKind.logPrefix(this.desc.sessionId), (Object)message);
            Tracing.traceRepair(message, new Object[0]);
            StreamPlan plan = this.createStreamPlan();
            plan.execute();
            this.planFuture.complete(plan);
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
        if (this.state == null) {
            return;
        }
        switch (event.eventType) {
            case STREAM_PREPARED: {
                StreamEvent.SessionPreparedEvent spe = (StreamEvent.SessionPreparedEvent)event;
                this.state.trace("Streaming session with {} prepared", (Object)spe.session.peer);
                break;
            }
            case STREAM_COMPLETE: {
                StreamEvent.SessionCompleteEvent sce = (StreamEvent.SessionCompleteEvent)event;
                this.state.trace("Streaming session with {} {}", (Object)sce.peer, (Object)(sce.success ? "completed successfully" : "failed"));
                break;
            }
            case FILE_PROGRESS: {
                ProgressInfo pi = ((StreamEvent.ProgressEvent)event).progress;
                this.state.trace("{}/{} ({}%) {} idx:{}{}", FBUtilities.prettyPrintMemory(pi.currentBytes), FBUtilities.prettyPrintMemory(pi.totalBytes), pi.currentBytes * 100L / pi.totalBytes, pi.direction == ProgressInfo.Direction.OUT ? "sent to" : "received from", pi.sessionIndex, pi.peer);
            }
        }
    }

    @Override
    public void onSuccess(StreamState result) {
        if (this.active.compareAndSet(true, false)) {
            String status = result.hasAbortedSession() ? "aborted" : "complete";
            String message = String.format("Sync %s using session %s between %s and %s on %s", status, this.desc.sessionId, this.nodePair.coordinator, this.nodePair.peer, this.desc.columnFamily);
            logger.info("{} {}", (Object)this.previewKind.logPrefix(this.desc.sessionId), (Object)message);
            Tracing.traceRepair(message, new Object[0]);
            this.set(result.hasAbortedSession() ? this.stat : this.stat.withSummaries(result.createSummaries()));
            this.finished();
        }
    }

    @Override
    public void onFailure(Throwable t) {
        if (this.active.compareAndSet(true, false)) {
            this.setException(t);
            this.finished();
        }
    }

    @Override
    public String toString() {
        return "LocalSyncTask{requestRanges=" + this.requestRanges + ", transferRanges=" + this.transferRanges + ", rangesToSync=" + this.rangesToSync + ", nodePair=" + this.nodePair + '}';
    }

    @Override
    public void abort() {
        this.planFuture.whenComplete((plan, cause) -> {
            assert (plan != null) : "StreamPlan future should never be completed exceptionally";
            plan.getCoordinator().getAllStreamSessions().forEach(StreamSession::abort);
        });
    }
}

