/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;

public class Lists<T>
extends Generator<List<T>> {
    final Generator<T> valueType;
    final T[] buffer;

    public Lists(String name, Generator<T> valueType, GeneratorConfig config) {
        super((AbstractType<?>)ListType.getInstance(valueType.type, (boolean)true), config, name, List.class);
        this.valueType = valueType;
        this.buffer = new Object[(int)this.sizeDistribution.maxValue()];
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.valueType.setSeed(seed * 31L);
    }

    @Override
    public List<T> generate() {
        int size = (int)this.sizeDistribution.next();
        for (int i = 0; i < size; ++i) {
            this.buffer[i] = this.valueType.generate();
        }
        return com.google.common.collect.Lists.newArrayList((Object[])Arrays.copyOf(this.buffer, size));
    }
}

