/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.AccessController;

final class ReflectiveTools {
    private static MethodHandle mh_getArray;
    private static MethodHandle mh_arrayOffset;

    ReflectiveTools() {
    }

    private static Void initReflection() {
        try {
            ReflectiveTools.enableByteBufferReflection();
        }
        catch (Throwable throwable) {
            ReflectiveTools.disableByteBufferReflection();
        }
        return null;
    }

    static void enableByteBufferReflection() throws NoSuchFieldException, IllegalAccessException {
        Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        field.setAccessible(true);
        MethodHandles.Lookup lookup = (MethodHandles.Lookup)field.get(null);
        mh_getArray = lookup.findGetter(ByteBuffer.class, "hb", byte[].class).asType(MethodType.methodType(byte[].class, ByteBuffer.class));
        mh_arrayOffset = lookup.findGetter(ByteBuffer.class, "offset", Integer.TYPE).asType(MethodType.methodType(Integer.class, ByteBuffer.class));
    }

    static void disableByteBufferReflection() {
        mh_getArray = MethodHandles.dropArguments(MethodHandles.constant(byte[].class, null), 0, new Class[]{ByteBuffer.class});
    }

    static byte[] getArray(ByteBuffer byteBuffer) {
        try {
            return mh_getArray.invokeExact(byteBuffer);
        }
        catch (Throwable throwable) {
            throw new Error("unexpected error", throwable);
        }
    }

    static int getArrayOffset(ByteBuffer byteBuffer) {
        try {
            return mh_arrayOffset.invokeExact(byteBuffer);
        }
        catch (Throwable throwable) {
            throw new Error("unexpected error", throwable);
        }
    }

    static {
        AccessController.doPrivileged(ReflectiveTools::initReflection);
    }
}

